/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.BackupForConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PartitionHandlingConfiguration;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.configuration.cache.SitesConfigurationBuilder;
import org.infinispan.configuration.cache.StateTransferConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheBuilder;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;

public class SharedStateCacheBuilder
extends ClusteredCacheBuilder {
    private final InjectedValue<PartitionHandlingConfiguration> partitionHandling = new InjectedValue();
    private final InjectedValue<StateTransferConfiguration> stateTransfer = new InjectedValue();
    private final InjectedValue<BackupForConfiguration> backupFor = new InjectedValue();
    private final InjectedValue<SitesConfiguration> backups = new InjectedValue();
    private final String containerName;
    private final String cacheName;

    SharedStateCacheBuilder(String containerName, String cacheName, CacheMode mode) {
        super(containerName, cacheName, mode);
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    @Override
    public ServiceBuilder<Configuration> build(ServiceTarget target) {
        return super.build(target).addDependency(CacheComponent.PARTITION_HANDLING.getServiceName(this.containerName, this.cacheName), PartitionHandlingConfiguration.class, this.partitionHandling).addDependency(CacheComponent.STATE_TRANSFER.getServiceName(this.containerName, this.cacheName), StateTransferConfiguration.class, this.stateTransfer).addDependency(CacheComponent.BACKUPS.getServiceName(this.containerName, this.cacheName), SitesConfiguration.class, this.backups).addDependency(CacheComponent.BACKUP_FOR.getServiceName(this.containerName, this.cacheName), BackupForConfiguration.class, this.backupFor);
    }

    @Override
    public void accept(ConfigurationBuilder builder) {
        super.accept(builder);
        builder.clustering().partitionHandling().read((PartitionHandlingConfiguration)this.partitionHandling.getValue());
        builder.clustering().stateTransfer().read((StateTransferConfiguration)this.stateTransfer.getValue());
        SitesConfigurationBuilder sitesBuilder = builder.sites();
        sitesBuilder.read((SitesConfiguration)this.backups.getValue());
        sitesBuilder.backupFor().read((BackupForConfiguration)this.backupFor.getValue());
    }
}

