/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.handlers;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.requestcontroller.RequestController;
import org.wildfly.extension.undertow.handlers.Handler;
import org.wildfly.extension.undertow.handlers.HandlerService;

class HandlerAdd
extends AbstractAddStepHandler {
    private Handler handler;

    HandlerAdd(Handler handler) {
        super(handler.getAttributes());
        this.handler = handler;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        HandlerService service = new HandlerService(this.handler.createHandler(context, model), name);
        CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addCapability(Handler.CAPABILITY, (Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
        RuntimeCapability newCapability = Handler.CAPABILITY.fromBaseCapability(context.getCurrentAddress());
        if (context.hasOptionalCapability("org.wildfly.request-controller", newCapability.getName(), null)) {
            builder.addCapabilityRequirement("org.wildfly.request-controller", RequestController.class, service.getRequestControllerInjectedValue());
        }
        builder.install();
    }
}

