/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import javax.naming.NamingException;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.LdapConnectionHandler;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

interface LdapSearcherCache<R, K> {
    public SearchResult<R> search(LdapConnectionHandler var1, K var2) throws IOException, NamingException;

    public int getCurrentSize();

    public void clearAll();

    public void clear(K var1);

    public boolean contains(K var1);

    public void clear(Predicate<K> var1);

    public int count(Predicate<K> var1);

    public static final class ServiceUtil {
        private static final String SERVICE_SUFFIX = "ldap.cache.%s.%s";
        private static final String AUTHENTICATION = "auth";
        private static final String AUTHORIZATION = "authz";
        private static final String USER = "user";
        private static final String GROUP = "group";

        private ServiceUtil() {
        }

        public static ServiceName createServiceName(boolean forAuthentication, boolean forUserSearch, String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{String.format(SERVICE_SUFFIX, forAuthentication ? AUTHENTICATION : AUTHORIZATION, forUserSearch ? USER : GROUP)});
        }

        public static <R, K> ServiceBuilder<?> addDependency(ServiceBuilder<?> sb, Class injectorType, Injector<LdapSearcherCache<R, K>> injector, boolean forAuthentication, boolean forUserSearch, String realmName) {
            sb.addDependency(ServiceBuilder.DependencyType.REQUIRED, ServiceUtil.createServiceName(forAuthentication, forUserSearch, realmName), injectorType, injector);
            return sb;
        }
    }

    public static final class AttachmentKey<T> {
        private final Class<T> valueClass;

        private AttachmentKey(Class<T> valueClass) {
            this.valueClass = valueClass;
        }

        public T cast(Object value) {
            return this.valueClass.cast(value);
        }

        public static <T> AttachmentKey<T> create(Class<? super T> valueClass) {
            return new AttachmentKey<T>(valueClass);
        }
    }

    public static interface SearchResult<R> {
        public R getResult();

        public <T> T getAttachment(AttachmentKey<T> var1);

        public <T> T attach(AttachmentKey<T> var1, T var2);

        public <T> T detach(AttachmentKey<T> var1);
    }

    public static interface Predicate<K> {
        public boolean matches(K var1);
    }
}

