/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import org.jboss.as.ee.metadata.EJBClientDescriptorMetaData;
import org.jboss.as.ee.structure.Attachments;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.processors.DiscoveryService;
import org.jboss.as.ejb3.remote.AssociationService;
import org.jboss.as.ejb3.remote.RemotingProfileService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.ejb.protocol.remote.RemoteEJBDiscoveryConfigurator;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.discovery.impl.StaticDiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryProvider;

public final class DiscoveryRegistrationProcessor
implements DeploymentUnitProcessor {
    private final boolean appClient;

    public DiscoveryRegistrationProcessor(boolean appClient) {
        this.appClient = appClient;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        EJBClientDescriptorMetaData ejbClientDescriptorMetaData;
        boolean useLocalReceiver;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getParent() != null) {
            return;
        }
        ServiceName clientContextName = (ServiceName)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_CLIENT_CONTEXT_SERVICE_NAME);
        ServiceName profileServiceName = (ServiceName)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_REMOTING_PROFILE_SERVICE_NAME);
        final DiscoveryService discoveryService = new DiscoveryService();
        ServiceName discoveryServiceName = DiscoveryService.BASE_NAME.append(new String[]{deploymentUnit.getName()});
        ServiceBuilder builder = phaseContext.getServiceTarget().addService(discoveryServiceName, (Service)discoveryService);
        Injector<DiscoveryProvider> providerInjector = discoveryService.getDiscoveryProviderInjector();
        new RemoteEJBDiscoveryConfigurator().configure(arg_0 -> providerInjector.inject(arg_0), registryProvider -> {});
        if (profileServiceName != null) {
            builder.addDependency(profileServiceName, RemotingProfileService.class, (Injector)new Injector<RemotingProfileService>(){
                Injector<DiscoveryProvider> providerInjector;
                {
                    this.providerInjector = discoveryService.getDiscoveryProviderInjector();
                }

                public void inject(RemotingProfileService value) throws InjectionException {
                    this.providerInjector.inject((Object)new StaticDiscoveryProvider(value.getServiceUrls()));
                }

                public void uninject() {
                    this.providerInjector.uninject();
                }
            });
        }
        boolean bl = useLocalReceiver = (ejbClientDescriptorMetaData = (EJBClientDescriptorMetaData)deploymentUnit.getAttachment(Attachments.EJB_CLIENT_METADATA)) == null || ejbClientDescriptorMetaData.isLocalReceiverExcluded() != Boolean.TRUE;
        if (useLocalReceiver && !this.appClient) {
            builder.addDependency(AssociationService.SERVICE_NAME, AssociationService.class, (Injector)new Injector<AssociationService>(){
                Injector<DiscoveryProvider> providerInjector;
                {
                    this.providerInjector = discoveryService.getDiscoveryProviderInjector();
                }

                public void inject(AssociationService value) throws InjectionException {
                    this.providerInjector.inject((Object)value.getLocalDiscoveryProvider());
                }

                public void uninject() {
                    this.providerInjector.uninject();
                }
            });
        }
        builder.install();
    }

    public void undeploy(DeploymentUnit context) {
    }
}

