/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.security.impl.SingleSignOnManager;
import io.undertow.server.session.SessionIdGenerator;
import io.undertow.server.session.SessionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.sso.SSOManagerFactory;
import org.wildfly.clustering.web.sso.SSOManagerFactoryBuilderProvider;
import org.wildfly.clustering.web.undertow.sso.DistributableSingleSignOnManager;
import org.wildfly.clustering.web.undertow.sso.SSOManagerBuilder;
import org.wildfly.clustering.web.undertow.sso.SessionIdGeneratorBuilder;
import org.wildfly.clustering.web.undertow.sso.SessionListenerBuilder;
import org.wildfly.clustering.web.undertow.sso.SessionManagerRegistry;
import org.wildfly.clustering.web.undertow.sso.SessionManagerRegistryBuilder;

public class DistributableSingleSignOnManagerBuilder
implements CapabilityServiceBuilder<SingleSignOnManager> {
    private final ServiceName name;
    private final ValueDependency<SSOManager> manager;
    private final ValueDependency<SessionManagerRegistry> registry;
    private final Collection<CapabilityServiceBuilder<?>> builders;

    public DistributableSingleSignOnManagerBuilder(ServiceName name, String serverName, String hostName, SSOManagerFactoryBuilderProvider<Batch> provider) {
        this.name = name;
        CapabilityServiceBuilder factoryBuilder = provider.getBuilder(hostName);
        ServiceName generatorServiceName = this.name.append(new String[]{"generator"});
        SessionIdGeneratorBuilder generatorBuilder = new SessionIdGeneratorBuilder(generatorServiceName, serverName);
        InjectedValueDependency factoryDependency = new InjectedValueDependency((ServiceNameProvider)factoryBuilder, SSOManagerFactory.class);
        InjectedValueDependency generatorDependency = new InjectedValueDependency(generatorServiceName, SessionIdGenerator.class);
        ServiceName managerServiceName = this.name.append(new String[]{"manager"});
        SSOManagerBuilder managerBuilder = new SSOManagerBuilder(managerServiceName, (ValueDependency<SSOManagerFactory>)factoryDependency, (ValueDependency<SessionIdGenerator>)generatorDependency, () -> null);
        InjectedValueDependency managerDependency = new InjectedValueDependency(managerServiceName, SSOManager.class);
        ServiceName listenerServiceName = this.name.append(new String[]{"listener"});
        SessionListenerBuilder listenerBuilder = new SessionListenerBuilder(listenerServiceName, (ValueDependency<SSOManager>)managerDependency);
        InjectedValueDependency listenerDependency = new InjectedValueDependency(listenerServiceName, SessionListener.class);
        ServiceName registryServiceName = this.name.append(new String[]{"registry"});
        SessionManagerRegistryBuilder registryBuilder = new SessionManagerRegistryBuilder(registryServiceName, serverName, hostName, (ValueDependency<SessionListener>)listenerDependency);
        this.manager = new InjectedValueDependency(managerBuilder, SSOManager.class);
        this.registry = new InjectedValueDependency((ServiceNameProvider)registryBuilder, SessionManagerRegistry.class);
        this.builders = Arrays.asList(factoryBuilder, generatorBuilder, managerBuilder, listenerBuilder, registryBuilder);
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public Builder<SingleSignOnManager> configure(CapabilityServiceSupport support) {
        this.builders.forEach(builder -> builder.configure(support));
        return this;
    }

    public ServiceBuilder<SingleSignOnManager> build(ServiceTarget target) {
        this.builders.forEach(builder -> builder.build(target).setInitialMode(ServiceController.Mode.ON_DEMAND).install());
        Value manager = () -> new DistributableSingleSignOnManager((SSOManager<AuthenticatedSessionManager.AuthenticatedSession, String, String, Void, Batch>)((SSOManager)this.manager.getValue()), (SessionManagerRegistry)this.registry.getValue());
        ServiceBuilder builder2 = target.addService(this.name, (Service)new ValueService(manager)).setInitialMode(ServiceController.Mode.ON_DEMAND);
        Stream.of(this.manager, this.registry).forEach(dependency -> dependency.register(builder2));
        return builder2;
    }
}

