/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing.impl;

import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.resource.transaction.TransactionCoordinatorBuilder;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class BatchTransactionalContext {
    private static final Log log = LoggerFactory.make();
    final SessionFactoryImplementor factory;
    final ErrorHandler errorHandler;
    final TransactionManager transactionManager;
    final TransactionCoordinatorBuilder transactionCoordinatorBuilder;
    final ExtendedSearchIntegrator extendedIntegrator;

    public BatchTransactionalContext(ExtendedSearchIntegrator extendedIntegrator, SessionFactoryImplementor sessionFactory, ErrorHandler errorHandler, String tenantId) {
        this.extendedIntegrator = extendedIntegrator;
        this.factory = sessionFactory;
        this.errorHandler = errorHandler;
        this.transactionManager = BatchTransactionalContext.lookupTransactionManager(this.factory);
        this.transactionCoordinatorBuilder = BatchTransactionalContext.lookupTransactionCoordinatorBuilder(this.factory);
    }

    private static TransactionCoordinatorBuilder lookupTransactionCoordinatorBuilder(SessionFactoryImplementor sessionFactory) {
        return (TransactionCoordinatorBuilder)sessionFactory.getServiceRegistry().getService(TransactionCoordinatorBuilder.class);
    }

    private static TransactionManager lookupTransactionManager(SessionFactoryImplementor sessionFactory) {
        return ((JtaPlatform)sessionFactory.getServiceRegistry().getService(JtaPlatform.class)).retrieveTransactionManager();
    }

    boolean wrapInTransaction() {
        if (!this.transactionCoordinatorBuilder.isJta()) {
            log.trace((Object)"TransactionFactory does not require a TransactionManager: don't wrap in a JTA transaction");
            return false;
        }
        if (this.transactionManager == null) {
            log.trace((Object)"No TransactionManager found, do not start a surrounding JTA transaction");
            return false;
        }
        try {
            if (this.transactionManager.getStatus() == 6) {
                log.trace((Object)"No Transaction in progress, needs to start a JTA transaction");
                return true;
            }
        }
        catch (SystemException e) {
            log.cannotGuessTransactionStatus((Exception)((Object)e));
            return false;
        }
        log.trace((Object)"Transaction in progress, no need to start a JTA transaction");
        return false;
    }
}

