/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.fine;

import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.ee.infinispan.CacheProperties;
import org.wildfly.clustering.marshalling.spi.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.SessionAttributes;
import org.wildfly.clustering.web.infinispan.session.SessionAttributesFactory;
import org.wildfly.clustering.web.infinispan.session.fine.FineImmutableSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.fine.FineSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeKey;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeNamesEntry;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeNamesKey;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;

public class FineSessionAttributesFactory<V>
implements SessionAttributesFactory<SessionAttributeNamesEntry> {
    private final Cache<SessionAttributeNamesKey, SessionAttributeNamesEntry> namesCache;
    private final Cache<SessionAttributeKey, V> attributeCache;
    private final Marshaller<Object, V> marshaller;
    private final CacheProperties properties;

    public FineSessionAttributesFactory(Cache<SessionAttributeNamesKey, SessionAttributeNamesEntry> namesCache, Cache<SessionAttributeKey, V> attributeCache, Marshaller<Object, V> marshaller, CacheProperties properties) {
        this.namesCache = namesCache;
        this.attributeCache = attributeCache;
        this.marshaller = marshaller;
        this.properties = properties;
    }

    public SessionAttributeNamesEntry createValue(String id, Void context) {
        SessionAttributeNamesEntry entry = new SessionAttributeNamesEntry(new AtomicInteger(), new ConcurrentHashMap<String, Integer>());
        this.namesCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)new SessionAttributeNamesKey(id), (Object)entry);
        return entry;
    }

    public SessionAttributeNamesEntry findValue(String id) {
        SessionAttributeNamesEntry entry = (SessionAttributeNamesEntry)this.namesCache.get((Object)new SessionAttributeNamesKey(id));
        if (entry != null) {
            ConcurrentMap<String, Integer> names = entry.getNames();
            Map attributes = this.attributeCache.getAdvancedCache().getAll(names.values().stream().map(attributeId -> new SessionAttributeKey(id, (int)attributeId)).collect(Collectors.toSet()));
            Predicate<Map.Entry> invalidAttribute = attribute -> {
                Object value = attribute.getValue();
                if (value == null) {
                    InfinispanWebLogger.ROOT_LOGGER.missingSessionAttributeCacheEntry(id, (String)attribute.getKey());
                    return true;
                }
                try {
                    this.marshaller.read(attribute.getValue());
                    return false;
                }
                catch (InvalidSerializedFormException e) {
                    InfinispanWebLogger.ROOT_LOGGER.failedToActivateSessionAttribute(e, id, (String)attribute.getKey());
                    return true;
                }
            };
            if (names.entrySet().stream().map(name -> new AbstractMap.SimpleImmutableEntry(name.getKey(), attributes.get((Object)new SessionAttributeKey(id, (Integer)name.getValue())))).anyMatch(invalidAttribute)) {
                this.remove(id);
                return null;
            }
        }
        return entry;
    }

    public boolean remove(String id) {
        SessionAttributeNamesEntry entry = (SessionAttributeNamesEntry)this.namesCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).remove((Object)new SessionAttributeNamesKey(id));
        if (entry == null) {
            return false;
        }
        entry.getNames().values().forEach(attributeId -> this.attributeCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)new SessionAttributeKey(id, (int)attributeId)));
        return true;
    }

    public boolean evict(String id) {
        SessionAttributeNamesKey key = new SessionAttributeNamesKey(id);
        SessionAttributeNamesEntry entry = (SessionAttributeNamesEntry)this.namesCache.getAdvancedCache().withFlags(EVICTION_FLAGS).get((Object)key);
        if (entry != null) {
            entry.getNames().entrySet().stream().forEach(attribute -> {
                try {
                    this.attributeCache.evict((Object)new SessionAttributeKey(id, (Integer)attribute.getValue()));
                }
                catch (Throwable e) {
                    InfinispanWebLogger.ROOT_LOGGER.failedToPassivateSessionAttribute(e, id, (String)attribute.getKey());
                }
            });
            this.namesCache.getAdvancedCache().withFlags(new Flag[]{Flag.FAIL_SILENTLY}).evict((Object)key);
        }
        return entry != null;
    }

    @Override
    public SessionAttributes createSessionAttributes(String id, SessionAttributeNamesEntry entry) {
        SessionAttributeNamesKey key = new SessionAttributeNamesKey(id);
        CacheEntryMutator mutator = this.properties.isTransactional() && this.namesCache.getAdvancedCache().getCacheEntry((Object)key).isCreated() ? Mutator.PASSIVE : new CacheEntryMutator(this.namesCache, (Object)key, (Object)entry);
        return new FineSessionAttributes<V>(id, entry.getSequence(), entry.getNames(), (Mutator)mutator, this.attributeCache, this.marshaller, this.properties);
    }

    @Override
    public ImmutableSessionAttributes createImmutableSessionAttributes(String id, SessionAttributeNamesEntry entry) {
        return new FineImmutableSessionAttributes<V>(id, entry.getNames(), this.attributeCache, this.marshaller);
    }
}

