/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.EnumSet;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.descriptions.HostResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class ServerProcessHandlers
implements OperationStepHandler {
    public static final OperationDefinition DESTROY_OPERATION = new SimpleOperationDefinitionBuilder("destroy", HostResolver.getResolver("host.server")).setReplyType(ModelType.UNDEFINED).setRuntimeOnly().withFlag(OperationEntry.Flag.HOST_CONTROLLER_ONLY).build();
    public static final OperationDefinition KILL_OPERATION = new SimpleOperationDefinitionBuilder("kill", HostResolver.getResolver("host.server")).setReplyType(ModelType.UNDEFINED).setRuntimeOnly().withFlag(OperationEntry.Flag.HOST_CONTROLLER_ONLY).build();
    final ServerInventory serverInventory;

    ServerProcessHandlers(ServerInventory serverInventory) {
        this.serverInventory = serverInventory;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        PathElement element = address.getLastElement();
        final String serverName = element.getValue();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.authorize(operation, EnumSet.of(Action.ActionEffect.WRITE_RUNTIME));
                context.completeStep(new OperationContext.ResultHandler(){

                    public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                        ServerProcessHandlers.this.doExecute(serverName);
                    }
                });
            }
        }, OperationContext.Stage.RUNTIME);
    }

    abstract void doExecute(String var1);

    public static class ServerKillHandler
    extends ServerProcessHandlers {
        public ServerKillHandler(ServerInventory serverInventory) {
            super(serverInventory);
        }

        @Override
        void doExecute(String serverName) {
            this.serverInventory.killServer(serverName);
        }
    }

    public static class ServerDestroyHandler
    extends ServerProcessHandlers {
        public ServerDestroyHandler(ServerInventory serverInventory) {
            super(serverInventory);
        }

        @Override
        void doExecute(String serverName) {
            this.serverInventory.destroyServer(serverName);
        }
    }
}

