/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;

public final class SecurityProviderServerMechanismFactory
implements HttpServerAuthenticationMechanismFactory {
    private static final String SERVICE_TYPE = HttpServerAuthenticationMechanismFactory.class.getSimpleName();
    private final Supplier<Provider[]> providerSupplier;

    public SecurityProviderServerMechanismFactory(Supplier<Provider[]> providerSupplier) {
        this.providerSupplier = (Supplier)Assert.checkNotNullParam((String)"providerSupplier", providerSupplier);
    }

    public SecurityProviderServerMechanismFactory() {
        this(Security::getProviders);
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> properties) {
        LinkedHashSet names = new LinkedHashSet();
        for (Provider current : this.providerSupplier.get()) {
            Set<Provider.Service> services = current.getServices();
            if (services == null) continue;
            for (Provider.Service currentService : services) {
                if (!SERVICE_TYPE.equals(currentService.getType())) continue;
                try {
                    String[] serviceMechNames = ((HttpServerAuthenticationMechanismFactory)currentService.newInstance(null)).getMechanismNames(properties);
                    Collections.addAll(names, serviceMechNames);
                }
                catch (NoSuchAlgorithmException e) {
                    ElytronMessages.log.debug("Unable to create instance", e);
                }
            }
        }
        if (names.size() == 0 && ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.tracef("No %s provided by provider loader in %s: %s", SERVICE_TYPE, this.getClass().getSimpleName(), Arrays.toString(this.providerSupplier.get()));
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    public HttpServerAuthenticationMechanism createAuthenticationMechanism(String mechanismName, Map<String, ?> properties, CallbackHandler callbackHandler) throws HttpAuthenticationException {
        for (Provider current : this.providerSupplier.get()) {
            Set<Provider.Service> services = current.getServices();
            if (services == null) continue;
            for (Provider.Service currentService : services) {
                if (!SERVICE_TYPE.equals(currentService.getType())) continue;
                try {
                    HttpServerAuthenticationMechanismFactory factory = (HttpServerAuthenticationMechanismFactory)currentService.newInstance(null);
                    HttpServerAuthenticationMechanism mechanism = factory.createAuthenticationMechanism(mechanismName, properties, callbackHandler);
                    if (mechanism == null) continue;
                    return mechanism;
                }
                catch (NoSuchAlgorithmException e) {
                    ElytronMessages.log.debug("Unable to create instance", e);
                }
            }
        }
        if (ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.tracef("No %s provided by provider loader in %s: %s", SERVICE_TYPE, this.getClass().getSimpleName(), Arrays.toString(this.providerSupplier.get()));
        }
        return null;
    }
}

