/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.util;

import java.util.concurrent.Callable;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.interceptor.proxy.InterceptorException;
import org.jboss.weld.interceptor.proxy.LifecycleMixin;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.resources.WeldClassLoaderResourceLoader;
import org.jboss.weld.util.reflection.Reflections;

public class InterceptionUtils {
    public static final String POST_CONSTRUCT = "lifecycle_mixin_$$_postConstruct";
    public static final String PRE_DESTROY = "lifecycle_mixin_$$_preDestroy";
    private static final String WELD_SE_CLASS = "org.jboss.weld.environment.se.Weld";
    private static final String WELD_SERVLET_CLASS = "org.jboss.weld.environment.servlet.WeldServletLifecycle";

    private InterceptionUtils() {
    }

    private static void executePostConstruct(Object proxy, Callable callback) {
        if (proxy instanceof LifecycleMixin) {
            LifecycleMixin lifecycleMixin = (LifecycleMixin)proxy;
            lifecycleMixin.lifecycle_mixin_$$_postConstruct();
        }
        if (callback != null) {
            try {
                callback.call();
            }
            catch (Exception e) {
                throw new InterceptorException(e);
            }
        }
    }

    public static void executePostConstruct(Object proxy) {
        InterceptionUtils.executePostConstruct(proxy, null);
    }

    private static void executePredestroy(Object proxy, Callable callback) {
        if (proxy instanceof LifecycleMixin) {
            LifecycleMixin lifecycleMixin = (LifecycleMixin)proxy;
            lifecycleMixin.lifecycle_mixin_$$_preDestroy();
        }
        if (callback != null) {
            try {
                callback.call();
            }
            catch (Exception e) {
                throw new InterceptorException(e);
            }
        }
    }

    public static void executePredestroy(Object proxy) {
        InterceptionUtils.executePredestroy(proxy, null);
    }

    static boolean isAnnotationClassExpected(InterceptionType interceptionType) {
        Environment environment;
        return !InterceptionType.POST_ACTIVATE.equals((Object)interceptionType) && !InterceptionType.PRE_PASSIVATE.equals((Object)interceptionType) || (environment = InterceptionUtils.detectEnvironment()) == null || !Environments.SE.equals((Object)environment) && !Environments.SERVLET.equals((Object)environment);
    }

    private static Environment detectEnvironment() {
        Environments environment = null;
        if (Reflections.isClassLoadable(WELD_SE_CLASS, WeldClassLoaderResourceLoader.INSTANCE)) {
            environment = Environments.SE;
        } else if (Reflections.isClassLoadable(WELD_SERVLET_CLASS, WeldClassLoaderResourceLoader.INSTANCE)) {
            environment = Environments.SERVLET;
        }
        return environment;
    }
}

