/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Collections;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.elytron.AuthenticationClientDefinitions;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.PermissionMapperDefinitions;
import org.wildfly.extension.elytron.PolicyDefinitions;

public final class ElytronSubsystemTransformers
implements ExtensionTransformerRegistration {
    public String getSubsystemName() {
        return "elytron";
    }

    public void registerTransformers(SubsystemTransformerRegistration registration) {
        ChainedTransformationDescriptionBuilder chainedBuilder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)registration.getCurrentSubsystemVersion());
        this.buildTransformers_1_1(chainedBuilder.createBuilder(registration.getCurrentSubsystemVersion(), ElytronExtension.ELYTRON_1_1_0));
        this.buildTransformers_1_0(chainedBuilder.createBuilder(ElytronExtension.ELYTRON_1_1_0, ElytronExtension.ELYTRON_1_0_0));
        chainedBuilder.buildAndRegister(registration, (ModelVersion[][])new ModelVersion[][]{{ElytronExtension.ELYTRON_1_1_0, ElytronExtension.ELYTRON_1_0_0}});
    }

    private void buildTransformers_1_1(ResourceTransformationDescriptionBuilder builder) {
        builder.addChildResource(PathElement.pathElement((String)"policy")).getAttributeBuilder().setValueConverter((AttributeConverter)new AttributeConverter.DefaultAttributeConverter(){

            protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                if (attributeValue.isDefined()) {
                    ModelNode element = attributeValue.clone();
                    element.get("name").set(address.getLastElement().getValue());
                    attributeValue.setEmptyList();
                    attributeValue.add(element);
                }
            }
        }, new AttributeDefinition[]{PolicyDefinitions.JaccPolicyDefinition.POLICY, PolicyDefinitions.CustomPolicyDefinition.POLICY});
    }

    private void buildTransformers_1_0(ResourceTransformationDescriptionBuilder builder) {
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"simple-permission-mapper")).getAttributeBuilder().setValueConverter((AttributeConverter)new AttributeConverter.DefaultAttributeConverter(){

            protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                if (attributeValue.isDefined()) {
                    String name = PermissionMapperDefinitions.MATCH_ALL.getName();
                    for (ModelNode element : attributeValue.asList()) {
                        if (!element.has(name) || element.hasDefined(name) && !"false".equals(element.get(name).asString())) continue;
                        element.remove(name);
                    }
                }
            }
        }, new AttributeDefinition[]{PermissionMapperDefinitions.PERMISSION_MAPPINGS})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.ListRejectAttributeChecker((RejectAttributeChecker)new RejectAttributeChecker.ObjectFieldsRejectAttributeChecker(Collections.singletonMap(PermissionMapperDefinitions.MATCH_ALL.getName(), RejectAttributeChecker.DEFINED))), new AttributeDefinition[]{PermissionMapperDefinitions.PERMISSION_MAPPINGS});
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"authentication-configuration")).getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode("authentication")}), new AttributeDefinition[]{AuthenticationClientDefinitions.FORWARDING_MODE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{AuthenticationClientDefinitions.FORWARDING_MODE});
    }
}

