/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jboss.as.webservices.dmr.ListInjector;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

public final class HandlerChainService
implements Service<UnifiedHandlerChainMetaData> {
    private final List<UnifiedHandlerMetaData> handlers = new ArrayList<UnifiedHandlerMetaData>(2);
    private final String handlerChainId;
    private final String protocolBindings;
    private volatile UnifiedHandlerChainMetaData handlerChain;

    public HandlerChainService(String handlerChainType, String handlerChainId, String protocolBindings) {
        if (!handlerChainType.equalsIgnoreCase("pre-handler-chain") && !handlerChainType.equals("post-handler-chain")) {
            throw new RuntimeException((Throwable)WSLogger.ROOT_LOGGER.wrongHandlerChainType(handlerChainType, "pre-handler-chain", "post-handler-chain"));
        }
        this.handlerChainId = handlerChainId;
        this.protocolBindings = protocolBindings;
    }

    public UnifiedHandlerChainMetaData getValue() {
        return this.handlerChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        Comparator<UnifiedHandlerMetaData> c = new Comparator<UnifiedHandlerMetaData>(){

            @Override
            public int compare(UnifiedHandlerMetaData o1, UnifiedHandlerMetaData o2) {
                return o1.getId().compareTo(o2.getId());
            }
        };
        List<UnifiedHandlerMetaData> list = this.handlers;
        synchronized (list) {
            Collections.sort(this.handlers, c);
        }
        this.handlerChain = new UnifiedHandlerChainMetaData(null, null, this.protocolBindings, this.handlers, false, this.handlerChainId);
    }

    public void stop(StopContext context) {
        this.handlerChain = null;
    }

    public Injector<UnifiedHandlerMetaData> getHandlersInjector() {
        return new ListInjector<UnifiedHandlerMetaData>(this.handlers);
    }
}

