/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.net.URI;
import org.jboss.ejb.client.AbstractEJBMetaData;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.EJBMetaDataImpl;
import org.jboss.ejb.client.NodeAffinity;
import org.jboss.ejb.client.URIAffinity;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.remoting3.Connection;
import org.wildfly.common.rpc.RemoteExceptionCause;

final class ProtocolV1ObjectResolver
implements ObjectResolver {
    private final NodeAffinity peerNodeAffinity;
    private final NodeAffinity selfNodeAffinity;
    private final URIAffinity peerUriAffinity;
    private final boolean preferUri;

    ProtocolV1ObjectResolver(Connection connection, boolean preferUri) {
        String remoteEndpointName = connection.getRemoteEndpointName();
        this.peerNodeAffinity = remoteEndpointName == null ? null : new NodeAffinity(remoteEndpointName);
        String localEndpointName = connection.getEndpoint().getName();
        this.selfNodeAffinity = localEndpointName == null ? null : new NodeAffinity(localEndpointName);
        this.preferUri = preferUri;
        URI peerURI = connection.getPeerURI();
        this.peerUriAffinity = peerURI == null ? null : (URIAffinity)Affinity.forUri(peerURI);
    }

    @Override
    public Object readResolve(Object replacement) {
        if (replacement instanceof EJBMetaDataImpl) {
            return ((EJBMetaDataImpl)replacement).toAbstractEJBMetaData();
        }
        if (replacement instanceof NodeAffinity) {
            if (replacement.equals(this.selfNodeAffinity)) {
                return Affinity.LOCAL;
            }
            if (this.preferUri && this.peerUriAffinity != null && replacement.equals(this.peerNodeAffinity)) {
                return this.peerUriAffinity;
            }
        } else if (replacement == Affinity.NONE) {
            return this.peerUriAffinity;
        }
        return replacement;
    }

    @Override
    public Object writeReplace(Object original) {
        if (original instanceof URIAffinity) {
            if (this.peerUriAffinity != null && original.equals(this.peerUriAffinity) && this.peerNodeAffinity != null) {
                return this.peerNodeAffinity;
            }
            return Affinity.NONE;
        }
        if (original == Affinity.LOCAL && this.selfNodeAffinity != null) {
            return this.selfNodeAffinity;
        }
        if (original instanceof AbstractEJBMetaData) {
            return new EJBMetaDataImpl((AbstractEJBMetaData)original);
        }
        if (original instanceof RemoteExceptionCause) {
            return ((RemoteExceptionCause)original).toPlainThrowable();
        }
        return original;
    }
}

