/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.service.concurrent;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.threads.JBossExecutors;
import org.wildfly.clustering.service.AsynchronousServiceBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.SuppliedValueService;

public class CachedThreadPoolExecutorServiceBuilder
implements Builder<ExecutorService> {
    private final ServiceName name;
    private final ThreadFactory factory;

    public CachedThreadPoolExecutorServiceBuilder(ServiceName name, ThreadFactory factory) {
        this.name = name;
        this.factory = factory;
    }

    @Override
    public ServiceName getServiceName() {
        return this.name;
    }

    @Override
    public ServiceBuilder<ExecutorService> build(ServiceTarget target) {
        Function<ExecutorService, ExecutorService> mapper = executor -> JBossExecutors.protectedExecutorService((Executor)executor);
        Supplier<ExecutorService> supplier = () -> Executors.newCachedThreadPool(this.factory);
        SuppliedValueService<ExecutorService, ExecutorService> service = new SuppliedValueService<ExecutorService, ExecutorService>(mapper, supplier, ExecutorService::shutdown);
        return new AsynchronousServiceBuilder(this.name, service).startSynchronously().build(target).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }
}

