/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery.spi;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.wildfly.common.Assert;
import org.wildfly.discovery.FilterSpec;
import org.wildfly.discovery.ServiceType;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryResult;

public interface BlockingDiscoveryProvider {
    public void discover(ServiceType var1, FilterSpec var2, DiscoveryResult var3) throws InterruptedException;

    default public DiscoveryProvider toDiscoveryProvider(Executor executor) {
        Assert.checkNotNullParam((String)"executor", (Object)executor);
        return (serviceType, filterSpec, result) -> {
            AtomicReference threadRef = new AtomicReference();
            try {
                executor.execute(() -> {
                    block8: {
                        try {
                            Thread currentThread = Thread.currentThread();
                            if (!threadRef.compareAndSet(null, currentThread)) break block8;
                            try {
                                this.discover(serviceType, filterSpec, result);
                            }
                            catch (InterruptedException e) {
                                currentThread.interrupt();
                            }
                            finally {
                                threadRef.set(null);
                            }
                        }
                        finally {
                            result.complete();
                        }
                    }
                });
            }
            catch (Throwable t) {
                result.complete();
            }
            return () -> {
                String val = threadRef.getAndSet("sentinel");
                if (val instanceof Thread) {
                    ((Thread)((Object)val)).interrupt();
                }
            };
        };
    }
}

