/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.spi;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jberet._private.BatchMessages;
import org.jberet.spi.JobOperatorContext;
import org.jberet.spi.JobOperatorContextSelector;
import org.jberet.util.Assertions;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ContextClassLoaderJobOperatorContextSelector
implements JobOperatorContextSelector {
    private final JobOperatorContextSelector defaultSelector;
    private final ConcurrentMap<ClassLoader, JobOperatorContext> contexts = new ConcurrentHashMap<ClassLoader, JobOperatorContext>();
    private final PrivilegedAction<JobOperatorContext> action = new PrivilegedAction<JobOperatorContext>(){

        @Override
        public JobOperatorContext run() {
            JobOperatorContext context;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null && (context = (JobOperatorContext)ContextClassLoaderJobOperatorContextSelector.this.contexts.get(cl)) != null) {
                return context;
            }
            return ContextClassLoaderJobOperatorContextSelector.this.defaultSelector.getJobOperatorContext();
        }
    };

    public ContextClassLoaderJobOperatorContextSelector(JobOperatorContextSelector defaultSelector) {
        this.defaultSelector = Assertions.notNull(defaultSelector, "defaultSelector");
    }

    @Override
    public JobOperatorContext getJobOperatorContext() {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(this.action);
        }
        return this.action.run();
    }

    public void registerContext(ClassLoader classLoader, JobOperatorContext context) {
        if (this.contexts.putIfAbsent(classLoader, context) != null) {
            throw BatchMessages.MESSAGES.classLoaderAlreadyRegistered(classLoader);
        }
    }

    public JobOperatorContext unregisterContext(ClassLoader classLoader) {
        return (JobOperatorContext)this.contexts.remove(classLoader);
    }

    public boolean unregisterContext(ClassLoader classLoader, JobOperatorContext context) {
        return this.contexts.remove(classLoader, context);
    }
}

