/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.launcher.logger;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import org.wildfly.core.launcher.logger.LauncherMessages;

public class LauncherMessages_$bundle
implements LauncherMessages,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final LauncherMessages_$bundle INSTANCE = new LauncherMessages_$bundle();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String pathDoesNotExist = "WFLYLNCHR0001: The path '%s' does not exist";
    private static final String invalidDirectory1 = "WFLYLNCHR0002: The directory '%s' is not a valid directory";
    private static final String invalidDirectory2 = "WFLYLNCHR0003: Invalid directory, could not find '%s' in '%s'";
    private static final String pathNotAFile = "WFLYLNCHR0004: Path '%s' is not a regular file.";
    private static final String nullParam = "WFLYLNCHR0005: The parameter %s cannot be null.";
    private static final String invalidHostname = "WFLYLNCHR0006: Invalid hostname: %s";

    protected LauncherMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String pathDoesNotExist$str() {
        return pathDoesNotExist;
    }

    @Override
    public final IllegalArgumentException pathDoesNotExist(Path path) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.pathDoesNotExist$str(), path));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidDirectory1$str() {
        return invalidDirectory1;
    }

    @Override
    public final IllegalArgumentException invalidDirectory(Path dir) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidDirectory1$str(), dir));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidDirectory2$str() {
        return invalidDirectory2;
    }

    @Override
    public final IllegalArgumentException invalidDirectory(String filename, Path dir) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidDirectory2$str(), filename, dir));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String pathNotAFile$str() {
        return pathNotAFile;
    }

    @Override
    public final IllegalArgumentException pathNotAFile(Path path) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.pathNotAFile$str(), path));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullParam$str() {
        return nullParam;
    }

    @Override
    public final IllegalArgumentException nullParam(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullParam$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidHostname$str() {
        return invalidHostname;
    }

    @Override
    public final IllegalArgumentException invalidHostname(CharSequence hostname) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidHostname$str(), hostname));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

