/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jmx.impl;

import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.jmx.IndexingProgressMonitorMBean;
import org.hibernate.search.jmx.StatisticsInfoMBean;
import org.hibernate.search.stat.Statistics;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class JMXRegistrar {
    private static final Log log = LoggerFactory.make();

    private JMXRegistrar() {
    }

    public static String buildMBeanName(String defaultName, String suffix) {
        String objectName = defaultName;
        if (!StringHelper.isEmpty(suffix)) {
            objectName = objectName + "[" + suffix + "]";
        }
        return objectName;
    }

    public static <T> String registerMBean(T object, Class<T> beanInterface, String name) {
        ObjectName objectName = JMXRegistrar.createObjectName(name);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            StandardMBean mbean = new StandardMBean(object, beanInterface);
            mbs.registerMBean(mbean, objectName);
        }
        catch (Exception e) {
            throw new SearchException("Unable to enable MBean for Hibernate Search", e);
        }
        return objectName.toString();
    }

    public static void unRegisterMBean(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The object name cannot be null");
        }
        ObjectName objectName = JMXRegistrar.createObjectName(name);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (mbs.isRegistered(objectName)) {
            try {
                mbs.unregisterMBean(objectName);
            }
            catch (Exception e) {
                log.unableToUnregisterExistingMBean(name, e);
            }
        }
    }

    public static boolean isNameRegistered(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The object name cannot be null");
        }
        ObjectName objectName = JMXRegistrar.createObjectName(name);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        return mbs.isRegistered(objectName);
    }

    private static ObjectName createObjectName(String name) {
        ObjectName objectName;
        try {
            objectName = new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new SearchException("Invalid JMX Bean name: " + name, e);
        }
        return objectName;
    }

    public static class IndexingProgressMonitor
    implements IndexingProgressMonitorMBean,
    MassIndexerProgressMonitor {
        private static final Log log = LoggerFactory.make();
        private final AtomicLong documentsDoneCounter = new AtomicLong();
        private final AtomicLong documentsBuiltCounter = new AtomicLong();
        private final AtomicLong totalCounter = new AtomicLong();
        private final AtomicLong entitiesLoadedCounter = new AtomicLong();
        private final String registeredName;

        public IndexingProgressMonitor() {
            String name = "org.hibernate.search.jmx:type=IndexingProgressMBean";
            if (JMXRegistrar.isNameRegistered(name)) {
                name = name + "@" + Integer.toHexString(this.hashCode());
            }
            this.registeredName = JMXRegistrar.registerMBean(this, IndexingProgressMonitorMBean.class, name);
        }

        @Override
        public final void documentsAdded(long increment) {
            this.documentsDoneCounter.addAndGet(increment);
        }

        @Override
        public final void documentsBuilt(int number) {
            this.documentsBuiltCounter.addAndGet(number);
        }

        @Override
        public final void entitiesLoaded(int size) {
            this.entitiesLoadedCounter.addAndGet(size);
        }

        @Override
        public final void addToTotalCount(long count) {
            this.totalCounter.addAndGet(count);
        }

        @Override
        public final void indexingCompleted() {
            log.indexingCompletedAndMBeanUnregistered(this.totalCounter.get());
            JMXRegistrar.unRegisterMBean(this.registeredName);
        }

        @Override
        public final long getLoadedEntitiesCount() {
            return this.entitiesLoadedCounter.get();
        }

        @Override
        public final long getDocumentsAddedCount() {
            return this.documentsDoneCounter.get();
        }

        @Override
        public final long getNumberOfEntitiesToIndex() {
            return this.totalCounter.get();
        }
    }

    public static class StatisticsInfo
    implements StatisticsInfoMBean {
        private final Statistics delegate;

        public StatisticsInfo(Statistics delegate) {
            this.delegate = delegate;
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public long getSearchQueryExecutionCount() {
            return this.delegate.getSearchQueryExecutionCount();
        }

        @Override
        public long getSearchQueryTotalTime() {
            return this.delegate.getSearchQueryTotalTime();
        }

        @Override
        public long getSearchQueryExecutionMaxTime() {
            return this.delegate.getSearchQueryExecutionMaxTime();
        }

        @Override
        public long getSearchQueryExecutionAvgTime() {
            return this.delegate.getSearchQueryExecutionAvgTime();
        }

        @Override
        public String getSearchQueryExecutionMaxTimeQueryString() {
            return this.delegate.getSearchQueryExecutionMaxTimeQueryString();
        }

        @Override
        public long getObjectLoadingTotalTime() {
            return this.delegate.getObjectLoadingTotalTime();
        }

        @Override
        public long getObjectLoadingExecutionMaxTime() {
            return this.delegate.getObjectLoadingExecutionMaxTime();
        }

        @Override
        public long getObjectLoadingExecutionAvgTime() {
            return this.delegate.getObjectLoadingExecutionAvgTime();
        }

        @Override
        public long getObjectsLoadedCount() {
            return this.delegate.getObjectsLoadedCount();
        }

        @Override
        public boolean isStatisticsEnabled() {
            return this.delegate.isStatisticsEnabled();
        }

        @Override
        public void setStatisticsEnabled(boolean b) {
            this.delegate.setStatisticsEnabled(b);
        }

        @Override
        public String getSearchVersion() {
            return this.delegate.getSearchVersion();
        }

        @Override
        public Set<String> getIndexedClassNames() {
            return this.delegate.getIndexedClassNames();
        }

        @Override
        public int getNumberOfIndexedEntities(String entity) {
            return this.delegate.getNumberOfIndexedEntities(entity);
        }

        @Override
        public Map<String, Integer> indexedEntitiesCount() {
            return this.delegate.indexedEntitiesCount();
        }
    }
}

