/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.core.config.Configuration;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.spi.ClusteringDefaultRequirement;
import org.wildfly.extension.messaging.activemq.AddIfAbsentStepHandler;
import org.wildfly.extension.messaging.activemq.BroadcastGroupDefinition;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.GroupBindingService;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.RemoteTransportDefinition;
import org.wildfly.extension.messaging.activemq.broadcast.CommandDispatcherBroadcastEndpointFactory;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class BroadcastGroupAdd
extends AbstractAddStepHandler {
    public static final BroadcastGroupAdd INSTANCE = new BroadcastGroupAdd();

    private BroadcastGroupAdd() {
        super(BroadcastGroupDefinition.ATTRIBUTES);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        CommonAttributes.renameChannelToCluster(operation);
        if (operation.hasDefined(CommonAttributes.JGROUPS_CLUSTER.getName()) && operation.hasDefined(BroadcastGroupDefinition.JGROUPS_CHANNEL_FACTORY.getName()) && !operation.hasDefined(BroadcastGroupDefinition.JGROUPS_CHANNEL.getName())) {
            String channel = operation.get(CommonAttributes.JGROUPS_CLUSTER.getName()).asString();
            operation.get(BroadcastGroupDefinition.JGROUPS_CHANNEL.getName()).set(channel);
            PathAddress channelAddress = context.getCurrentAddress().getParent().getParent().getParent().append("subsystem", "jgroups").append("channel", channel);
            ModelNode addChannelOperation = Util.createAddOperation((PathAddress)channelAddress);
            addChannelOperation.get("stack").set(operation.get(BroadcastGroupDefinition.JGROUPS_CHANNEL_FACTORY.getName()));
            context.addStep(addChannelOperation, (OperationStepHandler)AddIfAbsentStepHandler.INSTANCE, OperationContext.Stage.MODEL);
        }
        super.execute(context, operation);
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        context.registerCapability(BroadcastGroupDefinition.CAPABILITY.fromBaseCapability(address));
        ModelNode model = resource.getModel();
        if (CommonAttributes.JGROUPS_CLUSTER.resolveModelAttribute(context, model).isDefined() && !BroadcastGroupDefinition.JGROUPS_CHANNEL.resolveModelAttribute(context, model).isDefined()) {
            context.registerAdditionalCapabilityRequirement(ClusteringDefaultRequirement.COMMAND_DISPATCHER_FACTORY.getName(), BroadcastGroupDefinition.CAPABILITY.getDynamicName(address), BroadcastGroupDefinition.JGROUPS_CHANNEL_FACTORY.getName());
        }
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        final ModelNode connectorRefs = resource.getModel().get(BroadcastGroupDefinition.CONNECTOR_REFS.getName());
        if (connectorRefs.isDefined()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    BroadcastGroupDefinition.validateConnectors(context, operation, connectorRefs);
                }
            }, OperationContext.Stage.MODEL);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceName serviceName;
        ServiceRegistry registry = context.getServiceRegistry(false);
        ServiceController service = registry.getService(serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (service != null) {
            context.reloadRequired();
        } else {
            String name = context.getCurrentAddressValue();
            ServiceTarget target = context.getServiceTarget();
            if (!model.hasDefined(CommonAttributes.JGROUPS_CLUSTER.getName()) && model.hasDefined(RemoteTransportDefinition.SOCKET_BINDING.getName())) {
                GroupBindingService bindingService = new GroupBindingService();
                target.addService(GroupBindingService.getBroadcastBaseServiceName(serviceName).append(new String[]{name}), (Service)bindingService).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{model.get("socket-binding").asString()}), SocketBinding.class, bindingService.getBindingRef()).install();
            }
        }
    }

    static void addBroadcastGroupConfigs(OperationContext context, Configuration configuration, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("broadcast-group")) {
            List configs = configuration.getBroadcastGroupConfigurations();
            Set<String> connectors = configuration.getConnectorConfigurations().keySet();
            for (Property prop : model.get("broadcast-group").asPropertyList()) {
                configs.add(BroadcastGroupAdd.createBroadcastGroupConfiguration(context, connectors, prop.getName(), prop.getValue()));
            }
        }
    }

    static BroadcastGroupConfiguration createBroadcastGroupConfiguration(OperationContext context, Set<String> connectors, String name, ModelNode model) throws OperationFailedException {
        long broadcastPeriod = BroadcastGroupDefinition.BROADCAST_PERIOD.resolveModelAttribute(context, model).asLong();
        ArrayList<String> connectorRefs = new ArrayList<String>();
        if (model.hasDefined("connectors")) {
            for (ModelNode ref : model.get("connectors").asList()) {
                String refName = ref.asString();
                if (!connectors.contains(refName)) {
                    throw MessagingLogger.ROOT_LOGGER.wrongConnectorRefInBroadCastGroup(name, refName, connectors);
                }
                connectorRefs.add(refName);
            }
        }
        return new BroadcastGroupConfiguration().setName(name).setBroadcastPeriod(broadcastPeriod).setConnectorInfos(connectorRefs);
    }

    static BroadcastGroupConfiguration createBroadcastGroupConfiguration(String name, BroadcastGroupConfiguration config, SocketBinding socketBinding) throws Exception {
        String localAddress = socketBinding.getAddress().getHostAddress();
        String groupAddress = socketBinding.getMulticastAddress().getHostAddress();
        int localPort = socketBinding.getPort();
        int groupPort = socketBinding.getMulticastPort();
        long broadcastPeriod = config.getBroadcastPeriod();
        List connectorRefs = config.getConnectorInfos();
        UDPBroadcastEndpointFactory endpointFactory = new UDPBroadcastEndpointFactory().setGroupAddress(groupAddress).setGroupPort(groupPort).setLocalBindAddress(localAddress).setLocalBindPort(localPort);
        return new BroadcastGroupConfiguration().setName(name).setBroadcastPeriod(broadcastPeriod).setConnectorInfos(connectorRefs).setEndpointFactory((BroadcastEndpointFactory)endpointFactory);
    }

    static BroadcastGroupConfiguration createBroadcastGroupConfiguration(String name, BroadcastGroupConfiguration config, CommandDispatcherFactory commandDispatcherFactory, String channelName) throws Exception {
        long broadcastPeriod = config.getBroadcastPeriod();
        List connectorRefs = config.getConnectorInfos();
        CommandDispatcherBroadcastEndpointFactory endpointFactory = new CommandDispatcherBroadcastEndpointFactory(commandDispatcherFactory, channelName);
        return new BroadcastGroupConfiguration().setName(name).setBroadcastPeriod(broadcastPeriod).setConnectorInfos(connectorRefs).setEndpointFactory((BroadcastEndpointFactory)endpointFactory);
    }
}

