/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import javax.json.bind.JsonbException;
import org.eclipse.yasson.internal.RuntimeTypeInfo;
import org.eclipse.yasson.internal.VariableTypeInheritanceSearch;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.EmbeddedItem;
import org.eclipse.yasson.internal.serializer.ResolvedParameterizedType;

public class ReflectionUtils {
    private static final Logger logger = Logger.getLogger(ReflectionUtils.class.getName());

    public static Optional<Class<?>> getOptionalRawType(Type type) {
        if (type instanceof Class) {
            return Optional.of((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return Optional.of((Class)((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Optional.of(((GenericArrayType)type).getClass());
        }
        return Optional.empty();
    }

    public static Class<?> getRawType(Type type) {
        return ReflectionUtils.getOptionalRawType(type).orElseThrow(() -> new JsonbException(Messages.getMessage(MessageKeys.TYPE_RESOLUTION_ERROR, type)));
    }

    public static Class<?> resolveRawType(RuntimeTypeInfo item, Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return ReflectionUtils.getRawType(ReflectionUtils.resolveType(item, type));
    }

    public static Type resolveType(RuntimeTypeInfo item, Type type) {
        if (type instanceof WildcardType) {
            return ReflectionUtils.resolveMostSpecificBound(item, (WildcardType)type);
        }
        if (type instanceof TypeVariable) {
            return ReflectionUtils.resolveItemVariableType(item, (TypeVariable)type);
        }
        if (type instanceof ParameterizedType && item != null) {
            return ReflectionUtils.resolveTypeArguments((ParameterizedType)type, item.getRuntimeType());
        }
        return type;
    }

    public static Type resolveItemVariableType(RuntimeTypeInfo item, TypeVariable<?> typeVariable) {
        if (item == null) {
            logger.warning(Messages.getMessage(MessageKeys.GENERIC_BOUND_NOT_FOUND, typeVariable, typeVariable.getGenericDeclaration()));
            return Object.class;
        }
        if (item instanceof EmbeddedItem) {
            return ReflectionUtils.resolveItemVariableType(item.getWrapper(), typeVariable);
        }
        VariableTypeInheritanceSearch search = new VariableTypeInheritanceSearch();
        ParameterizedType wrapperParameterizedType = ReflectionUtils.findParameterizedSuperclass(item.getRuntimeType());
        Type foundType = search.searchParametrizedType(wrapperParameterizedType, typeVariable);
        if (foundType != null) {
            if (foundType instanceof TypeVariable) {
                return ReflectionUtils.resolveItemVariableType(item.getWrapper(), (TypeVariable)foundType);
            }
            return foundType;
        }
        return ReflectionUtils.resolveItemVariableType(item.getWrapper(), typeVariable);
    }

    public static Type resolveTypeArguments(ParameterizedType typeToResolve, Type typeToSearch) {
        Object[] unresolvedArgs = typeToResolve.getActualTypeArguments();
        Object[] resolvedArgs = new Type[unresolvedArgs.length];
        for (int i = 0; i < unresolvedArgs.length; ++i) {
            if (!(unresolvedArgs[i] instanceof TypeVariable)) {
                resolvedArgs[i] = unresolvedArgs[i];
            } else {
                resolvedArgs[i] = new VariableTypeInheritanceSearch().searchParametrizedType(typeToSearch, (TypeVariable)unresolvedArgs[i]);
                if (resolvedArgs[i] == null) {
                    throw new IllegalStateException(Messages.getMessage(MessageKeys.GENERIC_BOUND_NOT_FOUND, unresolvedArgs[i], typeToSearch));
                }
            }
            if (!(resolvedArgs[i] instanceof ParameterizedType)) continue;
            resolvedArgs[i] = ReflectionUtils.resolveTypeArguments((ParameterizedType)resolvedArgs[i], typeToSearch);
        }
        return Arrays.equals(resolvedArgs, unresolvedArgs) ? typeToResolve : new ResolvedParameterizedType(typeToResolve, (Type[])resolvedArgs);
    }

    public static <T> T createNoArgConstructorInstance(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        return (T)AccessController.doPrivileged(() -> {
            try {
                Constructor declaredConstructor = clazz.getDeclaredConstructor(new Class[0]);
                if (declaredConstructor.getModifiers() == 4) {
                    declaredConstructor.setAccessible(true);
                }
                return declaredConstructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new JsonbException("Can't create instance", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new JsonbException(Messages.getMessage(MessageKeys.NO_DEFAULT_CONSTRUCTOR, clazz), (Throwable)e);
            }
        });
    }

    public static ParameterizedType findParameterizedType(Class<?> classToSearch, Class<?> parameterizedInterface) {
        for (Class<?> current = classToSearch; current != Object.class; current = current.getSuperclass()) {
            for (Type currentInterface : current.getGenericInterfaces()) {
                if (!(currentInterface instanceof ParameterizedType) || !((ParameterizedType)currentInterface).getRawType().equals(parameterizedInterface)) continue;
                return (ParameterizedType)currentInterface;
            }
        }
        throw new JsonbException(Messages.getMessage(MessageKeys.NON_PARAMETRIZED_TYPE, parameterizedInterface));
    }

    public static boolean isResolvedType(Type type) {
        if (type instanceof ParameterizedType) {
            for (Type typeArg : ((ParameterizedType)type).getActualTypeArguments()) {
                if (ReflectionUtils.isResolvedType(typeArg)) continue;
                return false;
            }
            return true;
        }
        return type instanceof Class;
    }

    private static ParameterizedType findParameterizedSuperclass(Type type) {
        if (type == null || type instanceof ParameterizedType) {
            return (ParameterizedType)type;
        }
        if (!(type instanceof Class)) {
            throw new JsonbException("Can't resolve ParameterizedType superclass for: " + type);
        }
        return ReflectionUtils.findParameterizedSuperclass(((Class)type).getGenericSuperclass());
    }

    private static Type resolveMostSpecificBound(RuntimeTypeInfo item, WildcardType wildcardType) {
        Class result = Object.class;
        for (Type upperBound : wildcardType.getUpperBounds()) {
            result = ReflectionUtils.getMostSpecificBound(item, result, upperBound);
        }
        for (Type lowerBound : wildcardType.getLowerBounds()) {
            result = ReflectionUtils.getMostSpecificBound(item, result, lowerBound);
        }
        return result;
    }

    private static Class<?> getMostSpecificBound(RuntimeTypeInfo item, Class<?> result, Type bound) {
        if (bound == Object.class) {
            return result;
        }
        Type resolvedBoundType = bound instanceof TypeVariable ? ReflectionUtils.resolveType(item, bound) : bound;
        Class<?> boundRawType = ReflectionUtils.getRawType(resolvedBoundType);
        if (result.isAssignableFrom(boundRawType)) {
            result = boundRawType;
        }
        return result;
    }
}

