/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.Type;
import java.util.Objects;
import javax.json.bind.serializer.JsonbSerializer;
import javax.json.bind.serializer.SerializationContext;
import javax.json.stream.JsonGenerator;
import org.eclipse.yasson.internal.Marshaller;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.model.JsonBindingModel;
import org.eclipse.yasson.internal.serializer.AbstractItem;
import org.eclipse.yasson.internal.serializer.CurrentItem;
import org.eclipse.yasson.internal.serializer.SerializerBuilder;

public abstract class AbstractContainerSerializer<T>
extends AbstractItem<T>
implements JsonbSerializer<T> {
    private JsonbSerializer<?> valueSerializer;
    private Class<?> valueClass;

    protected AbstractContainerSerializer(SerializerBuilder builder) {
        super(builder);
    }

    public AbstractContainerSerializer(CurrentItem<?> wrapper, Type runtimeType, ClassModel classModel, JsonBindingModel wrapperModel) {
        super(wrapper, runtimeType, classModel, wrapperModel);
    }

    public final void serialize(T obj, JsonGenerator generator, SerializationContext ctx) {
        this.writeStart(generator);
        this.serializeInternal(obj, generator, ctx);
        this.writeEnd(generator);
    }

    protected abstract void serializeInternal(T var1, JsonGenerator var2, SerializationContext var3);

    protected abstract void writeStart(JsonGenerator var1);

    protected void writeEnd(JsonGenerator generator) {
        generator.writeEnd();
    }

    protected abstract void writeStart(String var1, JsonGenerator var2);

    protected <X> void serializerCaptor(JsonbSerializer<?> serializer, X object, JsonGenerator generator, SerializationContext ctx) {
        serializer.serialize(object, generator, ctx);
    }

    protected JsonbSerializer<?> getValueSerializer(Class<?> valueClass) {
        if (this.valueSerializer != null && valueClass == this.valueClass) {
            return this.valueSerializer;
        }
        return null;
    }

    protected void addValueSerializer(JsonbSerializer<?> valueSerializer, Class<?> valueClass) {
        Objects.requireNonNull(valueSerializer);
        Objects.requireNonNull(valueClass);
        this.valueSerializer = valueSerializer;
        this.valueClass = valueClass;
    }

    protected void serializeItem(Object item, JsonGenerator generator, SerializationContext ctx, JsonBindingModel model) {
        if (item == null) {
            generator.writeNull();
            return;
        }
        Class<?> itemClass = item.getClass();
        JsonbSerializer<?> serializer = this.getValueSerializer(itemClass);
        if (serializer == null) {
            serializer = ((SerializerBuilder)((SerializerBuilder)new SerializerBuilder(((Marshaller)ctx).getJsonbContext()).withObjectClass(itemClass).withWrapper(this)).withModel(model)).build();
            this.addValueSerializer(serializer, itemClass);
        }
        this.serializerCaptor(serializer, item, generator, ctx);
    }
}

