/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Locale;
import org.eclipse.yasson.internal.model.JsonBindingModel;
import org.eclipse.yasson.internal.serializer.AbstractDateTimeDeserializer;

public class DateTypeDeserializer
extends AbstractDateTimeDeserializer<Date> {
    private static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormatter.ISO_DATE_TIME.withZone(UTC);

    public DateTypeDeserializer(JsonBindingModel model) {
        super(Date.class, model);
    }

    @Override
    protected Date fromInstant(Instant instant) {
        return new Date(instant.toEpochMilli());
    }

    @Override
    protected Date parseDefault(String jsonValue, Locale locale) {
        TemporalAccessor parsed = DEFAULT_DATE_TIME_FORMATTER.withLocale(locale).parse(jsonValue);
        return new Date(Instant.from(parsed).toEpochMilli());
    }

    @Override
    protected Date parseWithFormatter(String jsonValue, DateTimeFormatter formatter) {
        TemporalAccessor parsed = this.getZonedFormatter(formatter).parse(jsonValue);
        return new Date(Instant.from(parsed).toEpochMilli());
    }
}

