/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.server.config.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.config.impl.Validators;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.jms.server.ActiveMQJMSServerLogger;
import org.apache.activemq.artemis.jms.server.config.JMSQueueConfiguration;
import org.apache.activemq.artemis.jms.server.config.TopicConfiguration;
import org.apache.activemq.artemis.jms.server.config.impl.JMSConfigurationImpl;
import org.apache.activemq.artemis.jms.server.config.impl.JMSQueueConfigurationImpl;
import org.apache.activemq.artemis.jms.server.config.impl.TopicConfigurationImpl;
import org.apache.activemq.artemis.jms.server.impl.JMSServerManagerImpl;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.utils.XMLConfigurationUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileJMSConfiguration
extends JMSConfigurationImpl
implements Deployable {
    private static final String CONFIGURATION_SCHEMA_URL = "schema/artemis-jms.xsd";
    private static final String CONFIGURATION_SCHEMA_ROOT_ELEMENT = "jms";
    private static final String NAME_ATTR = "name";
    private static final String QUEUE_NODE_NAME = "queue";
    private static final String QUEUE_SELECTOR_NODE_NAME = "selector";
    private static final String TOPIC_NODE_NAME = "topic";
    private static final String JMX_DOMAIN_NAME = "jmx-domain";
    private static final boolean DEFAULT_QUEUE_DURABILITY = true;
    private boolean parsed = false;

    public void parse(Element config, URL url) throws Exception {
        this.parseConfiguration(config);
        this.setConfigurationUrl(url);
        this.parsed = true;
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public String getRootElement() {
        return CONFIGURATION_SCHEMA_ROOT_ELEMENT;
    }

    public void buildService(ActiveMQSecurityManager securityManager, MBeanServer mBeanServer, Map<String, Deployable> deployables, Map<String, ActiveMQComponent> components) throws Exception {
        ActiveMQServerImpl server = (ActiveMQServerImpl)components.get("core");
        components.put(CONFIGURATION_SCHEMA_ROOT_ELEMENT, new JMSServerManagerImpl((ActiveMQServer)server, this));
    }

    public String getSchema() {
        return CONFIGURATION_SCHEMA_URL;
    }

    public void parseConfiguration(Node rootnode) throws Exception {
        String[] elements;
        ArrayList<JMSQueueConfiguration> queues = new ArrayList<JMSQueueConfiguration>();
        ArrayList<TopicConfiguration> topics = new ArrayList<TopicConfiguration>();
        Element e = (Element)rootnode;
        for (String element : elements = new String[]{QUEUE_NODE_NAME, TOPIC_NODE_NAME}) {
            NodeList children = e.getElementsByTagName(element);
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                Node keyNode = node.getAttributes().getNamedItem(NAME_ATTR);
                if (keyNode == null) {
                    ActiveMQJMSServerLogger.LOGGER.jmsConfigMissingKey(node);
                    continue;
                }
                if (node.getNodeName().equals(TOPIC_NODE_NAME)) {
                    topics.add(FileJMSConfiguration.parseTopicConfiguration(node));
                    continue;
                }
                if (!node.getNodeName().equals(QUEUE_NODE_NAME)) continue;
                queues.add(FileJMSConfiguration.parseQueueConfiguration(node));
            }
        }
        String domain = XMLConfigurationUtil.getString((Element)e, (String)JMX_DOMAIN_NAME, (String)ActiveMQDefaultConfiguration.getDefaultJmxDomain(), (Validators.Validator)Validators.NO_CHECK);
        this.newConfig(queues, topics, domain);
    }

    public static TopicConfiguration parseTopicConfiguration(Node node) throws Exception {
        String topicName = node.getAttributes().getNamedItem(NAME_ATTR).getNodeValue();
        return FileJMSConfiguration.newTopic(topicName);
    }

    public static JMSQueueConfiguration parseQueueConfiguration(Node node) throws Exception {
        Element e = (Element)node;
        NamedNodeMap atts = node.getAttributes();
        String queueName = atts.getNamedItem(NAME_ATTR).getNodeValue();
        String selectorString = null;
        boolean durable = XMLConfigurationUtil.getBoolean((Element)e, (String)"durable", (boolean)true);
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!QUEUE_SELECTOR_NODE_NAME.equals(children.item(i).getNodeName())) continue;
            Node selectorNode = children.item(i);
            Node attNode = selectorNode.getAttributes().getNamedItem("string");
            selectorString = attNode.getNodeValue();
        }
        return FileJMSConfiguration.newQueue(queueName, selectorString, durable);
    }

    protected static TopicConfiguration newTopic(String topicName) {
        return new TopicConfigurationImpl().setName(topicName);
    }

    protected static JMSQueueConfiguration newQueue(String queueName, String selectorString, boolean durable) {
        return new JMSQueueConfigurationImpl().setName(queueName).setSelector(selectorString).setDurable(durable);
    }

    protected void newConfig(ArrayList<JMSQueueConfiguration> queues, ArrayList<TopicConfiguration> topics, String domain) {
        ((JMSConfigurationImpl)((JMSConfigurationImpl)this.setQueueConfigurations(queues)).setTopicConfigurations(topics)).setDomain(domain);
    }
}

