/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;
import org.jberet._private.BatchLogger;
import org.jberet.job.model.Job;
import org.jberet.repository.AbstractRepository;
import org.jberet.repository.JobExecutionSelector;
import org.jberet.runtime.AbstractStepExecution;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.JobInstanceImpl;
import org.jberet.runtime.StepExecutionImpl;

public final class InMemoryRepository
extends AbstractRepository {
    private final ConcurrentMap<Long, JobInstanceImpl> jobInstances = new ConcurrentHashMap<Long, JobInstanceImpl>();
    private final ConcurrentMap<Long, JobExecutionImpl> jobExecutions = new ConcurrentHashMap<Long, JobExecutionImpl>();
    private final AtomicLong jobInstanceIdSequence = new AtomicLong();
    private final AtomicLong jobExecutionIdSequence = new AtomicLong();
    private final AtomicLong stepExecutionIdSequence = new AtomicLong();

    public static InMemoryRepository getInstance() {
        return Holder.instance;
    }

    public static InMemoryRepository create() {
        return new InMemoryRepository();
    }

    @Override
    public void removeJob(String jobId) {
        super.removeJob(jobId);
        Iterator it = this.jobInstances.entrySet().iterator();
        while (it.hasNext()) {
            JobInstance ji = (JobInstance)it.next().getValue();
            if (!ji.getJobName().equals(jobId)) continue;
            BatchLogger.LOGGER.removing(JobInstance.class.getName(), String.valueOf(ji.getInstanceId()));
            it.remove();
        }
        it = this.jobExecutions.entrySet().iterator();
        while (it.hasNext()) {
            JobExecution je = (JobExecution)it.next().getValue();
            if (!je.getJobName().equals(jobId)) continue;
            if (je.getJobParameters() != null) {
                je.getJobParameters().clear();
            }
            BatchLogger.LOGGER.removing(JobExecution.class.getName(), String.valueOf(je.getExecutionId()));
            it.remove();
        }
    }

    @Override
    void insertJobInstance(JobInstanceImpl jobInstance) {
        jobInstance.setId(this.jobInstanceIdSequence.incrementAndGet());
    }

    @Override
    void insertJobExecution(JobExecutionImpl jobExecution) {
        jobExecution.setId(this.jobExecutionIdSequence.incrementAndGet());
    }

    @Override
    void insertStepExecution(StepExecutionImpl stepExecution, JobExecutionImpl jobExecution) {
        stepExecution.setId(this.stepExecutionIdSequence.incrementAndGet());
    }

    @Override
    public void updateStepExecution(StepExecution stepExecution) {
    }

    @Override
    public int countStepStartTimes(String stepName, long jobInstanceId) {
        int count = 0;
        JobInstanceImpl jobInstanceImpl = (JobInstanceImpl)this.jobInstances.get(jobInstanceId);
        if (jobInstanceImpl != null) {
            for (JobExecution jobExecution : jobInstanceImpl.getJobExecutions()) {
                JobExecutionImpl jobExecutionImpl = (JobExecutionImpl)jobExecution;
                for (StepExecution stepExecution : jobExecutionImpl.getStepExecutions()) {
                    if (!stepExecution.getStepName().equals(stepName)) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    @Override
    public void removeJobExecutions(JobExecutionSelector jobExecutionSelector) {
        Set<Long> allJobExecutionIds = this.jobExecutions.keySet();
        Iterator it = this.jobExecutions.entrySet().iterator();
        while (it.hasNext()) {
            JobExecutionImpl je = (JobExecutionImpl)it.next().getValue();
            if (jobExecutionSelector != null && !jobExecutionSelector.select(je, allJobExecutionIds)) continue;
            if (je.getJobParameters() != null) {
                je.getJobParameters().clear();
            }
            BatchLogger.LOGGER.removing(JobExecution.class.getName(), String.valueOf(je.getExecutionId()));
            it.remove();
        }
    }

    @Override
    public JobInstanceImpl createJobInstance(Job job, String applicationName, ClassLoader classLoader) {
        JobInstanceImpl jobInstance = new JobInstanceImpl(job, applicationName, job.getId());
        this.insertJobInstance(jobInstance);
        this.jobInstances.put(jobInstance.getInstanceId(), jobInstance);
        return jobInstance;
    }

    @Override
    public void removeJobInstance(long jobInstanceIdToRemove) {
        BatchLogger.LOGGER.removing(JobInstance.class.getName(), String.valueOf(jobInstanceIdToRemove));
        this.jobInstances.remove(jobInstanceIdToRemove);
    }

    @Override
    public JobInstance getJobInstance(long jobInstanceId) {
        return (JobInstance)this.jobInstances.get(jobInstanceId);
    }

    @Override
    public List<JobInstance> getJobInstances(String jobName) {
        long largestJobInstanceId;
        ArrayList<JobInstance> result = new ArrayList<JobInstance>();
        for (long i = largestJobInstanceId = this.jobInstanceIdSequence.get(); i > 0L; --i) {
            JobInstanceImpl e = (JobInstanceImpl)this.jobInstances.get(i);
            if (e == null || !e.getJobName().equals(jobName)) continue;
            result.add(e);
        }
        return result;
    }

    @Override
    public int getJobInstanceCount(String jobName) {
        int count = 0;
        for (JobInstance e : this.jobInstances.values()) {
            if (!e.getJobName().equals(jobName)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public JobExecutionImpl createJobExecution(JobInstanceImpl jobInstance, Properties jobParameters) {
        JobExecutionImpl jobExecution = new JobExecutionImpl(jobInstance, jobParameters);
        this.insertJobExecution(jobExecution);
        this.jobExecutions.put(jobExecution.getExecutionId(), jobExecution);
        jobInstance.addJobExecution(jobExecution);
        return jobExecution;
    }

    @Override
    public JobExecutionImpl getJobExecution(long jobExecutionId) {
        return (JobExecutionImpl)this.jobExecutions.get(jobExecutionId);
    }

    @Override
    public List<JobExecution> getJobExecutions(JobInstance jobInstance) {
        if (jobInstance == null) {
            ArrayList<JobExecution> result = new ArrayList<JobExecution>();
            result.addAll(this.jobExecutions.values());
            return result;
        }
        return ((JobInstanceImpl)jobInstance).getJobExecutions();
    }

    @Override
    public List<StepExecution> getStepExecutions(long jobExecutionId, ClassLoader classLoader) {
        JobExecutionImpl jobExecution = this.getJobExecution(jobExecutionId);
        if (jobExecution == null) {
            return Collections.emptyList();
        }
        return jobExecution.getStepExecutions();
    }

    @Override
    public StepExecutionImpl findOriginalStepExecutionForRestart(String stepName, JobExecutionImpl jobExecutionToRestart, ClassLoader classLoader) {
        for (StepExecution stepExecution : jobExecutionToRestart.getStepExecutions()) {
            if (!stepName.equals(stepExecution.getStepName())) continue;
            return (StepExecutionImpl)stepExecution;
        }
        AbstractStepExecution result = null;
        long instanceId = jobExecutionToRestart.getJobInstance().getInstanceId();
        for (JobExecutionImpl jobExecutionImpl : this.jobExecutions.values()) {
            if (instanceId != jobExecutionImpl.getJobInstance().getInstanceId() || jobExecutionImpl.getExecutionId() == jobExecutionToRestart.getExecutionId()) continue;
            for (StepExecution stepExecution : jobExecutionImpl.getStepExecutions()) {
                if (!stepExecution.getStepName().equals(stepName) || result != null && result.getStepExecutionId() >= stepExecution.getStepExecutionId()) continue;
                result = (StepExecutionImpl)stepExecution;
            }
        }
        return result;
    }

    @Override
    public List<Long> getRunningExecutions(String jobName) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (Map.Entry e : this.jobExecutions.entrySet()) {
            BatchStatus s;
            if (!((JobExecutionImpl)e.getValue()).getJobName().equals(jobName) || (s = ((JobExecutionImpl)e.getValue()).getBatchStatus()) != BatchStatus.STARTING && s != BatchStatus.STARTED) continue;
            result.add((Long)e.getKey());
        }
        return result;
    }

    private static class Holder {
        private static final InMemoryRepository instance = new InMemoryRepository();

        private Holder() {
        }
    }
}

