/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.remoting.RemotingConnectorBindingInfoService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;
import org.wildfly.clustering.spi.ClusteringRequirement;

public class EJBRemotingConnectorClientMappingsEntryProviderService
implements CapabilityServiceBuilder<Map.Entry<String, List<ClientMapping>>>,
Value<Map.Entry<String, List<ClientMapping>>> {
    private final InjectedValue<RemotingConnectorBindingInfoService.RemotingConnectorInfo> remotingConnectorInfo = new InjectedValue();
    private final ServiceName remotingServerInfoServiceName;
    private volatile ValueDependency<Group> group;
    private volatile String clientMappingsClusterName;
    private volatile ServiceName name;

    public EJBRemotingConnectorClientMappingsEntryProviderService(String clientMappingsClusterName, ServiceName remotingServerInfoServiceName) {
        this.clientMappingsClusterName = clientMappingsClusterName;
        this.remotingServerInfoServiceName = remotingServerInfoServiceName;
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public Builder<Map.Entry<String, List<ClientMapping>>> configure(OperationContext context) {
        this.name = ClusteringCacheRequirement.REGISTRY_ENTRY.getServiceName(context, this.clientMappingsClusterName, "client-mappings");
        this.group = new InjectedValueDependency(ClusteringRequirement.GROUP.getServiceName(context, this.clientMappingsClusterName), Group.class);
        return this;
    }

    public ServiceBuilder<Map.Entry<String, List<ClientMapping>>> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.name, (Service)new ValueService((Value)this)).addDependency(this.remotingServerInfoServiceName, RemotingConnectorBindingInfoService.RemotingConnectorInfo.class, this.remotingConnectorInfo);
        return this.group.register(builder);
    }

    public Map.Entry<String, List<ClientMapping>> getValue() {
        return new AbstractMap.SimpleImmutableEntry<String, List<ClientMapping>>(((Group)this.group.getValue()).getLocalMember().getName(), this.getClientMappings());
    }

    List<ClientMapping> getClientMappings() {
        ArrayList<ClientMapping> ret = new ArrayList<ClientMapping>();
        RemotingConnectorBindingInfoService.RemotingConnectorInfo info = (RemotingConnectorBindingInfoService.RemotingConnectorInfo)this.remotingConnectorInfo.getValue();
        if (info.getSocketBinding().getClientMappings() != null && !info.getSocketBinding().getClientMappings().isEmpty()) {
            ret.addAll(info.getSocketBinding().getClientMappings());
        } else {
            InetAddress clientNetworkAddress;
            String destinationAddress = info.getSocketBinding().getAddress().getHostAddress();
            try {
                clientNetworkAddress = InetAddress.getByName("::");
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            ClientMapping defaultClientMapping = new ClientMapping(clientNetworkAddress, 0, destinationAddress, info.getSocketBinding().getAbsolutePort());
            ret.add(defaultClientMapping);
        }
        return ret;
    }
}

