/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.io;

import java.io.IOException;
import java.io.Writer;
import org.apache.velocity.io.Filter;

public final class VelocityWriter
extends Writer
implements Filter {
    public static final int NO_BUFFER = 0;
    public static final int DEFAULT_BUFFER = -1;
    public static final int UNBOUNDED_BUFFER = -2;
    private Writer writer = null;
    private int bufferSize;
    private boolean autoFlush;
    private char[] cb;
    private int nextChar;
    private static int defaultCharBufferSize = 8192;

    public VelocityWriter(Writer writer) {
        this(writer, defaultCharBufferSize, true);
    }

    private VelocityWriter(int n, boolean bl) {
        this.bufferSize = n;
        this.autoFlush = bl;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public VelocityWriter(Writer writer, int n, boolean bl) {
        this(n, bl);
        if (n < 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.writer = writer;
        this.cb = n == 0 ? null : new char[n];
        this.nextChar = 0;
    }

    private void flushBuffer() throws IOException {
        if (this.bufferSize == 0) {
            return;
        }
        if (this.nextChar == 0) {
            return;
        }
        this.writer.write(this.cb, 0, this.nextChar);
        this.nextChar = 0;
    }

    public final void clear() {
        this.nextChar = 0;
    }

    private void bufferOverflow() throws IOException {
        throw new IOException("overflow");
    }

    @Override
    public final void flush() throws IOException {
        this.flushBuffer();
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    @Override
    public final void close() throws IOException {
        if (this.writer == null) {
            return;
        }
        this.flush();
    }

    public final int getRemaining() {
        return this.bufferSize - this.nextChar;
    }

    @Override
    public final void write(int n) throws IOException {
        if (this.bufferSize == 0) {
            this.writer.write(n);
        } else {
            if (this.nextChar >= this.bufferSize) {
                if (this.autoFlush) {
                    this.flushBuffer();
                } else {
                    this.bufferOverflow();
                }
            }
            this.cb[this.nextChar++] = (char)n;
        }
    }

    private int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    @Override
    public final void write(char[] cArray, int n, int n2) throws IOException {
        if (this.bufferSize == 0) {
            this.writer.write(cArray, n, n2);
            return;
        }
        if (n2 == 0) {
            return;
        }
        if (n2 >= this.bufferSize) {
            if (this.autoFlush) {
                this.flushBuffer();
            } else {
                this.bufferOverflow();
            }
            this.writer.write(cArray, n, n2);
            return;
        }
        int n3 = n;
        int n4 = n + n2;
        while (n3 < n4) {
            int n5 = this.min(this.bufferSize - this.nextChar, n4 - n3);
            System.arraycopy(cArray, n3, this.cb, this.nextChar, n5);
            n3 += n5;
            this.nextChar += n5;
            if (this.nextChar < this.bufferSize) continue;
            if (this.autoFlush) {
                this.flushBuffer();
                continue;
            }
            this.bufferOverflow();
        }
    }

    @Override
    public final void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    @Override
    public final void write(String string, int n, int n2) throws IOException {
        if (this.bufferSize == 0) {
            this.writer.write(string, n, n2);
            return;
        }
        int n3 = n;
        int n4 = n + n2;
        while (n3 < n4) {
            int n5 = this.min(this.bufferSize - this.nextChar, n4 - n3);
            string.getChars(n3, n3 + n5, this.cb, this.nextChar);
            n3 += n5;
            this.nextChar += n5;
            if (this.nextChar < this.bufferSize) continue;
            if (this.autoFlush) {
                this.flushBuffer();
                continue;
            }
            this.bufferOverflow();
        }
    }

    @Override
    public final void write(String string) throws IOException {
        if (string != null) {
            this.write(string, 0, string.length());
        }
    }

    public final void recycle(Writer writer) {
        this.writer = writer;
        this.clear();
    }

    @Override
    public void writeReference(String string) throws IOException {
        this.write(string);
    }
}

