/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded;

import java.util.concurrent.CountDownLatch;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerService;
import org.jboss.as.host.controller.HostRunningModeControl;
import org.jboss.as.server.FutureServiceContainer;
import org.jboss.as.server.jmx.RunningStateJmx;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceTarget;

public class EmbeddedHostControllerBootstrap {
    private final ShutdownHook shutdownHook;
    private final ServiceContainer serviceContainer;
    private final HostControllerEnvironment environment;
    private final String authCode;
    private FutureServiceContainer futureContainer;

    public EmbeddedHostControllerBootstrap(FutureServiceContainer futureContainer, HostControllerEnvironment environment, String authCode) {
        this.environment = environment;
        this.authCode = authCode;
        this.shutdownHook = new ShutdownHook();
        this.serviceContainer = this.shutdownHook.register();
        this.futureContainer = futureContainer;
    }

    public FutureServiceContainer bootstrap() throws Exception {
        try {
            HostRunningModeControl runningModeControl = this.environment.getRunningModeControl();
            ControlledProcessState processState = new ControlledProcessState(true);
            this.shutdownHook.setControlledProcessState(processState);
            ServiceTarget target = this.serviceContainer.subTarget();
            ControlledProcessStateService controlledProcessStateService = (ControlledProcessStateService)ControlledProcessStateService.addService((ServiceTarget)target, (ControlledProcessState)processState).getValue();
            RunningStateJmx.registerMBean((ControlledProcessStateService)controlledProcessStateService, null, (RunningModeControl)runningModeControl, (boolean)false);
            HostControllerService hcs = new HostControllerService(this.environment, runningModeControl, this.authCode, processState, this.futureContainer);
            target.addService(HostControllerService.HC_SERVICE_NAME, hcs).install();
            return this.futureContainer;
        }
        catch (Error | RuntimeException e) {
            this.shutdownHook.run();
            throw e;
        }
    }

    public void failed() {
        this.shutdownHook.run();
    }

    private static class ShutdownHook
    extends Thread {
        private boolean down;
        private ControlledProcessState processState;
        private ServiceContainer container;

        private ShutdownHook() {
        }

        private ServiceContainer register() {
            Runtime.getRuntime().addShutdownHook(this);
            ShutdownHook shutdownHook = this;
            synchronized (shutdownHook) {
                if (!this.down) {
                    this.container = ServiceContainer.Factory.create("host-controller", false);
                    return this.container;
                }
                throw new IllegalStateException();
            }
        }

        private synchronized void setControlledProcessState(ControlledProcessState ps) {
            this.processState = ps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block13: {
                CountDownLatch latch;
                ControlledProcessState ps;
                ServiceContainer sc;
                ShutdownHook shutdownHook = this;
                synchronized (shutdownHook) {
                    this.down = true;
                    sc = this.container;
                    ps = this.processState;
                }
                try {
                    if (ps != null) {
                        ps.setStopping();
                    }
                    if (sc == null) break block13;
                    latch = new CountDownLatch(1);
                    sc.addTerminateListener(new ServiceContainer.TerminateListener(this, latch){
                        final /* synthetic */ CountDownLatch val$latch;
                        final /* synthetic */ ShutdownHook this$0;
                        {
                            this.this$0 = this$0;
                            this.val$latch = countDownLatch;
                        }

                        @Override
                        public void handleTermination(ServiceContainer.TerminateListener.Info info) {
                            this.val$latch.countDown();
                        }
                    });
                    sc.shutdown();
                }
                catch (Throwable throwable) {
                    if (sc != null) {
                        CountDownLatch latch2 = new CountDownLatch(1);
                        sc.addTerminateListener(new /* invalid duplicate definition of identical inner class */);
                        sc.shutdown();
                        while (true) {
                            try {
                                latch2.await();
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                    }
                    throw throwable;
                }
                while (true) {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
    }
}

