/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.net.SocketAddress;
import java.util.List;
import java.util.function.Consumer;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.impl.operations.AddClientListenerOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HintedReplayingDecoder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.util.Either;

public class HeaderOrEventDecoder
extends HintedReplayingDecoder<Void> {
    private static final Log log = LogFactory.getLog(HeaderOrEventDecoder.class);
    private final Codec codec;
    private final HeaderParams params;
    private final ChannelFactory channelFactory;
    private final AddClientListenerOperation operation;
    private final Consumer<ClientEvent> eventConsumer;
    private final byte[] listenerId;
    private final Configuration configuration;

    public HeaderOrEventDecoder(Codec codec, HeaderParams params, ChannelFactory channelFactory, AddClientListenerOperation operation, Consumer<ClientEvent> eventConsumer, byte[] listenerId, Configuration configuration) {
        this.codec = codec;
        this.params = params;
        this.channelFactory = channelFactory;
        this.operation = operation;
        this.eventConsumer = eventConsumer;
        this.listenerId = listenerId;
        this.configuration = configuration;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        this.codec.readMessageId(in);
        Either<Short, ClientEvent> either = this.codec.readHeaderOrEvent(in, this.params, this.listenerId, this.channelFactory.getMarshaller(), this.configuration.serialWhitelist(), this.channelFactory, ctx.channel().remoteAddress());
        switch (either.type()) {
            case LEFT: {
                this.operation.acceptResponse(in, (Short)either.left(), null);
                break;
            }
            case RIGHT: {
                this.operation.postponeTimeout(ctx.channel());
                this.eventConsumer.accept((ClientEvent)either.right());
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.operation.exceptionCaught(ctx, cause);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        SocketAddress address = ctx.channel().remoteAddress();
        this.operation.exceptionCaught(ctx, log.connectionClosed(address, address));
    }
}

