/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import java.util.function.Function;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.MappedValueService;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.web.undertow.UndertowUnaryRequirement;
import org.wildfly.extension.undertow.Server;

public class RouteBuilder
implements CapabilityServiceBuilder<String>,
Function<Server, String> {
    private final String serverName;
    private volatile ValueDependency<Server> server;

    public RouteBuilder(String serverName) {
        this.serverName = serverName;
    }

    @Override
    public String apply(Server server) {
        return server.getRoute();
    }

    public ServiceName getServiceName() {
        return ServiceName.JBOSS.append(new String[]{"clustering", "web", "route", this.serverName});
    }

    public Builder<String> configure(CapabilityServiceSupport support) {
        this.server = new InjectedValueDependency(UndertowUnaryRequirement.SERVER.getServiceName(support, this.serverName), Server.class);
        return this;
    }

    public ServiceBuilder<String> build(ServiceTarget target) {
        MappedValueService service = new MappedValueService((Function)this, this.server);
        return this.server.register(target.addService(this.getServiceName(), (Service)service)).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }
}

