/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso.elytron;

import io.undertow.server.session.SessionIdGenerator;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.ImmediateValueDependency;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.MappedValueService;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.sso.SSOManagerFactory;
import org.wildfly.clustering.web.sso.SSOManagerFactoryBuilderProvider;
import org.wildfly.clustering.web.undertow.sso.SSOManagerBuilder;
import org.wildfly.clustering.web.undertow.sso.elytron.DistributableSingleSignOnManager;
import org.wildfly.clustering.web.undertow.sso.elytron.ElytronAuthentication;
import org.wildfly.clustering.web.undertow.sso.elytron.LocalSSOContext;
import org.wildfly.clustering.web.undertow.sso.elytron.LocalSSOContextFactory;
import org.wildfly.security.http.util.sso.SingleSignOnManager;

public class DistributableSingleSignOnManagerBuilder
implements CapabilityServiceBuilder<SingleSignOnManager>,
Function<SSOManager<ElytronAuthentication, String, Map.Entry<String, URI>, LocalSSOContext, Batch>, SingleSignOnManager> {
    private final ServiceName name;
    private final ValueDependency<SSOManager<ElytronAuthentication, String, Map.Entry<String, URI>, LocalSSOContext, Batch>> manager;
    private final Collection<CapabilityServiceBuilder<?>> builders;

    public DistributableSingleSignOnManagerBuilder(ServiceName name, String securityDomainName, SessionIdGenerator generator, SSOManagerFactoryBuilderProvider<Batch> provider) {
        this.name = name;
        CapabilityServiceBuilder factoryBuilder = provider.getBuilder(securityDomainName);
        InjectedValueDependency factoryDependency = new InjectedValueDependency((ServiceNameProvider)factoryBuilder, SSOManagerFactory.class);
        ImmediateValueDependency generatorDependency = new ImmediateValueDependency((Object)generator);
        ServiceName managerServiceName = this.name.append(new String[]{"manager"});
        SSOManagerBuilder managerBuilder = new SSOManagerBuilder(managerServiceName, factoryDependency, (ValueDependency<SessionIdGenerator>)generatorDependency, new LocalSSOContextFactory());
        this.manager = new InjectedValueDependency(managerServiceName, SSOManager.class);
        this.builders = Arrays.asList(factoryBuilder, managerBuilder);
    }

    @Override
    public SingleSignOnManager apply(SSOManager<ElytronAuthentication, String, Map.Entry<String, URI>, LocalSSOContext, Batch> manager) {
        return new DistributableSingleSignOnManager(manager);
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public Builder<SingleSignOnManager> configure(CapabilityServiceSupport support) {
        for (CapabilityServiceBuilder<?> builder : this.builders) {
            builder.configure(support);
        }
        return this;
    }

    public ServiceBuilder<SingleSignOnManager> build(ServiceTarget target) {
        for (CapabilityServiceBuilder<?> builder : this.builders) {
            builder.build(target).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        }
        MappedValueService service = new MappedValueService((Function)this, this.manager);
        return this.manager.register(target.addService(this.name, (Service)service)).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }
}

