/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal.bytebuddy;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.TypeCache;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import org.hibernate.HibernateException;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.proxy.pojo.bytebuddy.ByteBuddyProxyFactory;

public final class ByteBuddyState {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(ByteBuddyProxyFactory.class);
    private static final ByteBuddy buddy = new ByteBuddy().with(TypeValidation.DISABLED);
    private static final TypeCache<TypeCache.SimpleKey> CACHE = new TypeCache.WithInlineExpunction(TypeCache.Sort.WEAK);
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

    public ByteBuddy getCurrentyByteBuddy() {
        return buddy;
    }

    @Deprecated
    public static TypeCache<TypeCache.SimpleKey> getCacheForProxies() {
        return CACHE;
    }

    void clearState() {
        CACHE.clear();
    }

    @Deprecated
    public static ByteBuddy getStaticByteBuddyInstance() {
        return buddy;
    }

    public static ClassLoadingStrategy<?> resolveClassLoadingStrategy(Class<?> originalClass) {
        if (ClassInjector.UsingLookup.isAvailable()) {
            Method privateLookupIn;
            try {
                privateLookupIn = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
            }
            catch (Exception e) {
                throw new HibernateException(LOG.bytecodeEnhancementFailed(originalClass.getName()), e);
            }
            try {
                Object privateLookup;
                try {
                    privateLookup = privateLookupIn.invoke(null, originalClass, LOOKUP);
                }
                catch (InvocationTargetException exception) {
                    if (exception.getCause() instanceof IllegalAccessException) {
                        return new ClassLoadingStrategy.ForUnsafeInjection(originalClass.getProtectionDomain());
                    }
                    throw new HibernateException(LOG.bytecodeEnhancementFailed(originalClass.getName()), exception.getCause());
                }
                return ClassLoadingStrategy.UsingLookup.of((Object)privateLookup);
            }
            catch (Throwable e) {
                throw new HibernateException(LOG.bytecodeEnhancementFailedUnableToGetPrivateLookupFor(originalClass.getName()), e);
            }
        }
        return new ClassLoadingStrategy.ForUnsafeInjection(originalClass.getProtectionDomain());
    }
}

