/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.v53.impl;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.ExtendedStatisticsSupport;
import org.hibernate.cache.spi.Region;
import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;
import org.infinispan.hibernate.cache.commons.InfinispanBaseRegion;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.hibernate.cache.v53.InfinispanRegionFactory;

abstract class BaseRegionImpl
implements Region,
InfinispanBaseRegion,
ExtendedStatisticsSupport {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(BaseRegionImpl.class);
    protected final String name;
    protected final AdvancedCache cache;
    protected final AdvancedCache localAndSkipLoadCache;
    protected final InfinispanRegionFactory factory;
    protected volatile long lastRegionInvalidation = Long.MIN_VALUE;
    protected int invalidations = 0;

    public BaseRegionImpl(AdvancedCache cache, String name, InfinispanRegionFactory factory) {
        this.cache = cache;
        this.name = name;
        this.factory = factory;
        this.localAndSkipLoadCache = cache.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.SKIP_CACHE_LOAD});
    }

    public String getName() {
        return this.name;
    }

    public long nextTimestamp() {
        return this.factory.nextTimestamp();
    }

    public void destroy() throws CacheException {
        this.cache.stop();
    }

    public boolean checkValid() {
        return this.lastRegionInvalidation != Long.MAX_VALUE;
    }

    public void clear() {
        this.invalidateRegion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginInvalidation() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Begin invalidating region: " + this.name));
        }
        BaseRegionImpl baseRegionImpl = this;
        synchronized (baseRegionImpl) {
            this.lastRegionInvalidation = Long.MAX_VALUE;
            ++this.invalidations;
        }
        this.runInvalidation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endInvalidation() {
        BaseRegionImpl baseRegionImpl = this;
        synchronized (baseRegionImpl) {
            if (--this.invalidations == 0) {
                this.lastRegionInvalidation = this.factory.nextTimestamp();
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("End invalidating region: " + this.name));
        }
    }

    public long getLastRegionInvalidation() {
        return this.lastRegionInvalidation;
    }

    public AdvancedCache getCache() {
        return this.cache;
    }

    protected void runInvalidation() {
        log.tracef("Non-transactional, clear in one go", new Object[0]);
        this.localAndSkipLoadCache.clear();
    }

    public InfinispanRegionFactory getRegionFactory() {
        return this.factory;
    }

    public long getElementCountInMemory() {
        return this.localAndSkipLoadCache.size();
    }

    public long getElementCountOnDisk() {
        return Long.MIN_VALUE;
    }

    public long getSizeInMemory() {
        return Long.MIN_VALUE;
    }
}

