/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.service.Builder;

public class ModuleBuilder
implements ResourceServiceBuilder<Module>,
Service<Module> {
    private final InjectedValue<ModuleLoader> loader = new InjectedValue();
    private final ServiceName name;
    private final Attribute attribute;
    private volatile String identifier;
    private volatile Module module;

    public ModuleBuilder(ServiceName name, Attribute attribute) {
        this.name = name;
        this.attribute = attribute;
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public ServiceBuilder<Module> build(ServiceTarget target) {
        return target.addService(this.name, (Service)this).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, this.loader).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public Builder<Module> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.identifier = this.attribute.resolveModelAttribute((ExpressionResolver)context, model).asString();
        return this;
    }

    public void start(StartContext context) throws StartException {
        try {
            this.module = ((ModuleLoader)this.loader.getValue()).loadModule(this.identifier);
        }
        catch (ModuleLoadException e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext context) {
        this.module = null;
    }

    public Module getValue() {
        return this.module;
    }
}

