/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.io.IOException;
import java.lang.ref.WeakReference;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.SerializabilityChecker;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;

public class SimpleMarshallingContext
implements MarshallingContext {
    private final MarshallerFactory factory;
    private final MarshallingConfigurationRepository repository;
    private final WeakReference<ClassLoader> loader;

    public SimpleMarshallingContext(MarshallerFactory factory, MarshallingConfigurationRepository repository, ClassLoader loader) {
        this.factory = factory;
        this.repository = repository;
        this.loader = new WeakReference<ClassLoader>(loader);
    }

    @Override
    public ClassLoader getClassLoader() {
        return (ClassLoader)this.loader.get();
    }

    @Override
    public int getCurrentVersion() {
        return this.repository.getCurrentMarshallingVersion();
    }

    @Override
    public Unmarshaller createUnmarshaller(int version) throws IOException {
        return this.factory.createUnmarshaller(this.getMarshallingConfiguration(version));
    }

    @Override
    public Marshaller createMarshaller(int version) throws IOException {
        return this.factory.createMarshaller(this.getMarshallingConfiguration(version));
    }

    private MarshallingConfiguration getMarshallingConfiguration(int version) {
        return this.repository.getMarshallingConfiguration(version);
    }

    public boolean isMarshallable(Object object) {
        if (object == null) {
            return true;
        }
        MarshallingConfiguration configuration = this.repository.getMarshallingConfiguration(this.repository.getCurrentMarshallingVersion());
        try {
            ObjectTable table = configuration.getObjectTable();
            if (table != null && table.getObjectWriter(object) != null) {
                return true;
            }
            ClassExternalizerFactory factory = configuration.getClassExternalizerFactory();
            if (factory != null && factory.getExternalizer(object.getClass()) != null) {
                return true;
            }
            SerializabilityChecker checker = configuration.getSerializabilityChecker();
            return (checker == null ? SerializabilityChecker.DEFAULT : checker).isSerializable(object.getClass());
        }
        catch (IOException e) {
            return false;
        }
    }
}

