/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.infinispan.transaction.LockingMode;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.MetricExecutor;
import org.jboss.as.clustering.controller.MetricHandler;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleAliasEntry;
import org.jboss.as.clustering.controller.SimpleResourceRegistration;
import org.jboss.as.clustering.controller.SimpleResourceServiceHandler;
import org.jboss.as.clustering.controller.transform.AttributeOperationTransformer;
import org.jboss.as.clustering.controller.transform.ChainedOperationTransformer;
import org.jboss.as.clustering.controller.transform.OperationTransformer;
import org.jboss.as.clustering.controller.transform.RequiredChildResourceDiscardPolicy;
import org.jboss.as.clustering.controller.transform.SimpleOperationTransformer;
import org.jboss.as.clustering.controller.validation.EnumValidator;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ComponentResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.TransactionBuilder;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMetric;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMetricExecutor;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMode;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.DynamicDiscardPolicy;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class TransactionResourceDefinition
extends ComponentResourceDefinition {
    static final PathElement PATH = TransactionResourceDefinition.pathElement("transaction");
    static final PathElement LEGACY_PATH = PathElement.pathElement((String)PATH.getValue(), (String)"TRANSACTION");

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = InfinispanModel.VERSION_4_0_0.requiresTransformation(version) ? parent.addChildRedirection(PATH, LEGACY_PATH, (DynamicDiscardPolicy)RequiredChildResourceDiscardPolicy.NEVER) : parent.addChildResource(PATH);
        LinkedList<org.jboss.as.controller.transform.OperationTransformer> addOperationTransformers = new LinkedList<org.jboss.as.controller.transform.OperationTransformer>();
        LinkedList<org.jboss.as.controller.transform.OperationTransformer> removeOperationTransformers = new LinkedList<org.jboss.as.controller.transform.OperationTransformer>();
        HashMap<String, org.jboss.as.controller.transform.OperationTransformer> readAttributeTransformers = new HashMap<String, org.jboss.as.controller.transform.OperationTransformer>();
        HashMap<String, org.jboss.as.controller.transform.OperationTransformer> writeAttributeTransformers = new HashMap<String, org.jboss.as.controller.transform.OperationTransformer>();
        HashMap<String, org.jboss.as.controller.transform.OperationTransformer> undefineAttributeTransformers = new HashMap<String, org.jboss.as.controller.transform.OperationTransformer>();
        if (InfinispanModel.VERSION_3_0_0.requiresTransformation(version)) {
            OperationTransformer addTransformer = new OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    ModelNode mode;
                    if (operation.hasDefined(Attribute.MODE.getName()) && (mode = operation.get(Attribute.MODE.getName())).getType() == ModelType.STRING && TransactionMode.valueOf(mode.asString()) == TransactionMode.BATCH) {
                        mode.set(TransactionMode.NONE.name());
                        PathAddress address = Operations.getPathAddress((ModelNode)operation);
                        return Operations.createCompositeOperation((ModelNode[])new ModelNode[]{operation, Operations.createWriteAttributeOperation((PathAddress)TransactionResourceDefinition.cacheAddress(address), (org.jboss.as.clustering.controller.Attribute)CacheResourceDefinition.DeprecatedAttribute.BATCHING, (ModelNode)new ModelNode(true))});
                    }
                    return operation;
                }
            };
            addOperationTransformers.add((org.jboss.as.controller.transform.OperationTransformer)new SimpleOperationTransformer(addTransformer));
            OperationTransformer removeTransformer = new OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    PathAddress address = Operations.getPathAddress((ModelNode)operation);
                    return Operations.createCompositeOperation((ModelNode[])new ModelNode[]{operation, Operations.createUndefineAttributeOperation((PathAddress)TransactionResourceDefinition.cacheAddress(address), (org.jboss.as.clustering.controller.Attribute)CacheResourceDefinition.DeprecatedAttribute.BATCHING)});
                }
            };
            removeOperationTransformers.add((org.jboss.as.controller.transform.OperationTransformer)new SimpleOperationTransformer(removeTransformer));
            OperationTransformer readAttributeOperationTransformer = new OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    PathAddress address = Operations.getPathAddress((ModelNode)operation);
                    return Operations.createCompositeOperation((ModelNode[])new ModelNode[]{Operations.createReadAttributeOperation((PathAddress)TransactionResourceDefinition.cacheAddress(address), (org.jboss.as.clustering.controller.Attribute)CacheResourceDefinition.DeprecatedAttribute.BATCHING), operation});
                }
            };
            OperationResultTransformer readAttributeResultTransformer = new OperationResultTransformer(){

                public ModelNode transformResult(ModelNode result) {
                    ModelNode readBatchingResult = result.get(0);
                    return readBatchingResult.asBoolean() ? new ModelNode(TransactionMode.BATCH.name()) : result.get(1);
                }
            };
            readAttributeTransformers.put(Attribute.MODE.getName(), (org.jboss.as.controller.transform.OperationTransformer)new SimpleOperationTransformer(readAttributeOperationTransformer, readAttributeResultTransformer));
            OperationTransformer writeAttributeTransformer = new OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    boolean batching;
                    ModelNode mode = Operations.getAttributeValue((ModelNode)operation);
                    boolean bl = mode.isDefined() && mode.getType() == ModelType.STRING ? TransactionMode.valueOf(mode.asString()) == TransactionMode.BATCH : (batching = false);
                    if (batching) {
                        mode.set(TransactionMode.NONE.name());
                    }
                    PathAddress address = Operations.getPathAddress((ModelNode)operation);
                    return Operations.createCompositeOperation((ModelNode[])new ModelNode[]{operation, Operations.createWriteAttributeOperation((PathAddress)TransactionResourceDefinition.cacheAddress(address), (org.jboss.as.clustering.controller.Attribute)CacheResourceDefinition.DeprecatedAttribute.BATCHING, (ModelNode)new ModelNode(batching))});
                }
            };
            writeAttributeTransformers.put(Attribute.MODE.getName(), (org.jboss.as.controller.transform.OperationTransformer)new SimpleOperationTransformer(writeAttributeTransformer));
            OperationTransformer undefineAttributeTransformer = new OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    PathAddress address = Operations.getPathAddress((ModelNode)operation);
                    return Operations.createCompositeOperation((ModelNode[])new ModelNode[]{operation, Operations.createUndefineAttributeOperation((PathAddress)TransactionResourceDefinition.cacheAddress(address), (org.jboss.as.clustering.controller.Attribute)CacheResourceDefinition.DeprecatedAttribute.BATCHING)});
                }
            };
            undefineAttributeTransformers.put(Attribute.MODE.getName(), (org.jboss.as.controller.transform.OperationTransformer)new SimpleOperationTransformer(undefineAttributeTransformer));
            ResourceTransformer modeTransformer = new ResourceTransformer(){

                public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
                    ModelNode value;
                    ModelNode model = resource.getModel();
                    if (model.hasDefined(Attribute.MODE.getName()) && (value = model.get(Attribute.MODE.getName())).getType() == ModelType.STRING && TransactionMode.valueOf(value.asString()) == TransactionMode.BATCH) {
                        value.set(TransactionMode.NONE.name());
                    }
                    context.addTransformedResource(PathAddress.EMPTY_ADDRESS, resource).processChildren(resource);
                }
            };
            builder.setCustomResourceTransformer(modeTransformer);
            builder.getAttributeBuilder().setValueConverter((AttributeConverter)new AttributeConverter.DefaultValueAttributeConverter(Attribute.STOP_TIMEOUT.getDefinition()), new AttributeDefinition[]{Attribute.STOP_TIMEOUT.getDefinition()});
        }
        TransactionResourceDefinition.buildOperationTransformation(builder, "add", addOperationTransformers);
        TransactionResourceDefinition.buildOperationTransformation(builder, "remove", removeOperationTransformers);
        TransactionResourceDefinition.buildOperationTransformation(builder, "read-attribute", readAttributeTransformers);
        TransactionResourceDefinition.buildOperationTransformation(builder, "write-attribute", writeAttributeTransformers);
        TransactionResourceDefinition.buildOperationTransformation(builder, "undefine-attribute", undefineAttributeTransformers);
    }

    static void buildOperationTransformation(ResourceTransformationDescriptionBuilder builder, String operationName, List<org.jboss.as.controller.transform.OperationTransformer> transformers) {
        if (!transformers.isEmpty()) {
            builder.addOperationTransformationOverride(operationName).setCustomOperationTransformer((org.jboss.as.controller.transform.OperationTransformer)new ChainedOperationTransformer(transformers)).inheritResourceAttributeDefinitions();
        }
    }

    static void buildOperationTransformation(ResourceTransformationDescriptionBuilder builder, String operationName, Map<String, org.jboss.as.controller.transform.OperationTransformer> transformers) {
        if (!transformers.isEmpty()) {
            builder.addOperationTransformationOverride(operationName).setCustomOperationTransformer((org.jboss.as.controller.transform.OperationTransformer)new AttributeOperationTransformer(transformers)).inheritResourceAttributeDefinitions();
        }
    }

    static PathAddress cacheAddress(PathAddress transactionAddress) {
        return transactionAddress.subAddress(0, transactionAddress.size() - 1);
    }

    TransactionResourceDefinition() {
        super(PATH);
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        parent.registerAlias(LEGACY_PATH, (AliasEntry)new SimpleAliasEntry((org.jboss.as.controller.registry.ManagementResourceRegistration)registration));
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class);
        SimpleResourceServiceHandler handler = new SimpleResourceServiceHandler(TransactionBuilder::new);
        new SimpleResourceRegistration(descriptor, (ResourceServiceHandler)handler).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        if (registration.isRuntimeOnlyRegistrationValid()) {
            new MetricHandler((MetricExecutor)new TransactionMetricExecutor(), TransactionMetric.class).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        }
        return registration;
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        LOCKING("locking", ModelType.STRING, new ModelNode(LockingMode.PESSIMISTIC.name())){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setValidator((ParameterValidator)new EnumValidator(LockingMode.class));
            }
        }
        ,
        MODE("mode", ModelType.STRING, new ModelNode(TransactionMode.NONE.name())){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setValidator((ParameterValidator)new EnumValidator(TransactionMode.class));
            }
        }
        ,
        STOP_TIMEOUT("stop-timeout", ModelType.LONG, new ModelNode(10000L)){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setMeasurementUnit(MeasurementUnit.MILLISECONDS);
            }
        };

        private final SimpleAttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = ((SimpleAttributeDefinitionBuilder)this.apply(((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}))).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

