/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import javax.net.ssl.SSLContext;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.SecurityConfiguration;
import org.infinispan.client.hotrod.configuration.SecurityConfigurationBuilder;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.infinispan.subsystem.ComponentBuilder;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.remote.SecurityResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class SecurityBuilder
extends ComponentBuilder<SecurityConfiguration>
implements ResourceServiceBuilder<SecurityConfiguration> {
    private volatile ValueDependency<SSLContext> sslContextDependency;

    SecurityBuilder(PathAddress address) {
        super(RemoteCacheContainerComponent.SECURITY, address);
    }

    public Builder<SecurityConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String sslContext = SecurityResourceDefinition.Attribute.SSL_CONTEXT.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        this.sslContextDependency = sslContext != null ? new InjectedValueDependency(CommonUnaryRequirement.SSL_CONTEXT.getServiceName(context, sslContext), SSLContext.class) : null;
        return this;
    }

    @Override
    public ServiceBuilder<SecurityConfiguration> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).setInitialMode(ServiceController.Mode.ON_DEMAND);
        return this.sslContextDependency != null ? this.sslContextDependency.register(builder) : builder;
    }

    public SecurityConfiguration getValue() throws IllegalStateException, IllegalArgumentException {
        SecurityConfigurationBuilder securityBuilder = new ConfigurationBuilder().security();
        SSLContext sslContext = this.sslContextDependency != null ? (SSLContext)this.sslContextDependency.getValue() : null;
        securityBuilder.ssl().sslContext(sslContext).enabled(sslContext != null);
        return securityBuilder.create();
    }
}

