/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.clustering.logging.ClusteringLogger;
import org.jboss.threads.JBossThreadFactory;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.Marshaller;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.Response;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.NameCache;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.GroupListener;
import org.wildfly.clustering.group.Membership;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.server.dispatcher.AutoCloseableCommandDispatcherFactory;
import org.wildfly.clustering.server.dispatcher.ChannelCommandDispatcher;
import org.wildfly.clustering.server.dispatcher.ChannelCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherMarshaller;
import org.wildfly.clustering.server.dispatcher.CommandResponseMarshaller;
import org.wildfly.clustering.server.dispatcher.LocalCommandDispatcher;
import org.wildfly.clustering.server.dispatcher.NoSuchService;
import org.wildfly.clustering.server.dispatcher.ViewMembership;
import org.wildfly.clustering.server.group.AddressableNode;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;
import org.wildfly.clustering.service.concurrent.ClassLoaderThreadFactory;
import org.wildfly.clustering.service.concurrent.ServiceExecutor;
import org.wildfly.clustering.service.concurrent.StampedLockServiceExecutor;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ChannelCommandDispatcherFactory
implements AutoCloseableCommandDispatcherFactory,
RequestHandler,
org.wildfly.clustering.server.group.Group<Address>,
MembershipListener,
Runnable {
    private final ConcurrentMap<Address, Node> members = new ConcurrentHashMap<Address, Node>();
    private final Map<Object, Optional<Object>> contexts = new ConcurrentHashMap<Object, Optional<Object>>();
    private final ExecutorService executorService = Executors.newCachedThreadPool(ChannelCommandDispatcherFactory.createThreadFactory(this.getClass()));
    private final ServiceExecutor executor = new StampedLockServiceExecutor();
    private final Map<GroupListener, ExecutorService> listeners = new ConcurrentHashMap<GroupListener, ExecutorService>();
    private final AtomicReference<View> view = new AtomicReference();
    private final MarshallingContext marshallingContext;
    private final MessageDispatcher dispatcher;
    private final long timeout;

    private static ThreadFactory createThreadFactory(Class<?> targetClass) {
        PrivilegedAction<ThreadFactory> action = () -> new ClassLoaderThreadFactory((ThreadFactory)new JBossThreadFactory(new ThreadGroup(targetClass.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null), targetClass.getClassLoader());
        return (ThreadFactory)WildFlySecurityManager.doUnchecked(action);
    }

    public ChannelCommandDispatcherFactory(ChannelCommandDispatcherFactoryConfiguration config) {
        this.marshallingContext = config.getMarshallingContext();
        this.timeout = config.getTimeout();
        JChannel channel = config.getChannel();
        RequestCorrelator correlator = new RequestCorrelator((Protocol)channel.getProtocolStack().getTransport(), (RequestHandler)this, channel.getAddress()).setMarshaller((Marshaller)new CommandResponseMarshaller(config));
        this.dispatcher = new MessageDispatcher().setChannel(channel).setRequestHandler((RequestHandler)this).setMembershipListener((MembershipListener)this).asyncDispatching(true).correlator(correlator);
        this.view.compareAndSet(null, channel.getView());
    }

    @Override
    public void run() {
        this.dispatcher.stop();
        this.dispatcher.getChannel().setUpHandler(null);
        for (ExecutorService executor : this.listeners.values()) {
            PrivilegedAction<List> action = () -> executor.shutdownNow();
            WildFlySecurityManager.doUnchecked(action);
        }
        this.listeners.clear();
        this.executorService.shutdownNow();
    }

    @Override
    public void close() {
        this.executor.close((Runnable)this);
    }

    public Object handle(Message request) throws Exception {
        return this.read(request).call();
    }

    public void handle(Message request, Response response) throws Exception {
        Callable<Object> task = this.read(request);
        this.executorService.submit(() -> {
            try {
                response.send(task.call(), false);
            }
            catch (Exception e) {
                response.send((Object)e, true);
            }
        });
    }

    /*
     * Exception decompiling
     */
    private Callable<Object> read(Message message) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Group getGroup() {
        return this;
    }

    public <C> CommandDispatcher<C> createCommandDispatcher(Object id, C context) {
        if (this.contexts.putIfAbsent(id, Optional.ofNullable(context)) != null) {
            throw ClusteringServerLogger.ROOT_LOGGER.commandDispatcherAlreadyExists(id);
        }
        CommandDispatcherMarshaller marshaller = new CommandDispatcherMarshaller(this.marshallingContext, id);
        LocalCommandDispatcher localDispatcher = new LocalCommandDispatcher(this.getLocalMember(), context);
        return new ChannelCommandDispatcher(this.dispatcher, marshaller, this, this.timeout, localDispatcher, () -> {
            localDispatcher.close();
            this.contexts.remove(id);
        });
    }

    public Registration register(GroupListener listener) {
        this.listeners.computeIfAbsent(listener, key -> Executors.newSingleThreadExecutor(ChannelCommandDispatcherFactory.createThreadFactory(listener.getClass())));
        return () -> this.unregister(listener);
    }

    private void unregister(GroupListener listener) {
        ExecutorService executor = this.listeners.remove(listener);
        if (executor != null) {
            executor.shutdownNow();
            try {
                executor.awaitTermination(this.timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Deprecated
    public void removeListener(Group.Listener listener) {
        this.unregister((GroupListener)listener);
    }

    public String getName() {
        return this.dispatcher.getChannel().getClusterName();
    }

    public Membership getMembership() {
        return new ViewMembership(this.dispatcher.getChannel().getAddress(), this.view.get(), this);
    }

    public Node getLocalMember() {
        return this.createNode(this.dispatcher.getChannel().getAddress());
    }

    public boolean isSingleton() {
        return false;
    }

    public Node createNode(Address address) {
        return this.members.computeIfAbsent(address, key -> {
            IpAddress ipAddress = (IpAddress)this.dispatcher.getChannel().down(new Event(87, (Object)address));
            InetSocketAddress socketAddress = ipAddress != null ? new InetSocketAddress(ipAddress.getIpAddress(), ipAddress.getPort()) : new InetSocketAddress(0);
            String name = Optional.ofNullable(NameCache.get((Address)address)).orElseGet(() -> String.format("%s:%s", socketAddress.getHostString(), socketAddress.getPort()));
            return new AddressableNode(address, name, socketAddress);
        });
    }

    public Address getAddress(Node node) {
        return ((AddressableNode)node).getAddress();
    }

    public void viewAccepted(View view) {
        View oldView = this.view.getAndSet(view);
        if (oldView != null) {
            List leftMembers = View.leftMembers((View)oldView, (View)view);
            if (leftMembers != null) {
                this.members.keySet().removeAll(leftMembers);
            }
            if (this.listeners.isEmpty()) {
                Address localAddress = this.dispatcher.getChannel().getAddress();
                ViewMembership oldMembership = new ViewMembership(localAddress, oldView, this);
                ViewMembership membership = new ViewMembership(localAddress, view, this);
                for (Map.Entry<GroupListener, ExecutorService> entry : this.listeners.entrySet()) {
                    GroupListener listener = entry.getKey();
                    ExecutorService executor = entry.getValue();
                    try {
                        executor.submit(() -> {
                            try {
                                listener.membershipChanged((Membership)oldMembership, (Membership)membership, view instanceof MergeView);
                            }
                            catch (Throwable e) {
                                ClusteringLogger.ROOT_LOGGER.warn((Object)e.getLocalizedMessage(), e);
                            }
                        });
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {}
                }
            }
        }
    }

    public void suspect(Address member) {
    }

    public void block() {
    }

    public void unblock() {
    }

    private /* synthetic */ Object lambda$read$5(ExceptionSupplier task) throws Exception {
        return this.executor.execute(task).orElse(Optional.of(NoSuchService.INSTANCE)).orElse(null);
    }

    private static /* synthetic */ Optional lambda$read$4(Command command, Optional context) throws Exception {
        return Optional.ofNullable(command.execute(context.orElse(null)));
    }

    private static /* synthetic */ Object lambda$read$3() throws Exception {
        return NoSuchService.INSTANCE;
    }
}

