/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.server.dispatcher.AutoCloseableCommandDispatcherFactory;
import org.wildfly.clustering.server.dispatcher.ManagedCommandDispatcher;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;

public class ManagedCommandDispatcherFactory
implements AutoCloseableCommandDispatcherFactory {
    private final CommandDispatcherFactory factory;
    private final Map<Object, Map.Entry<CommandDispatcher<?>, Integer>> dispatchers = new HashMap();
    private final Runnable closeTask;

    public ManagedCommandDispatcherFactory(AutoCloseableCommandDispatcherFactory factory) {
        this(factory, () -> factory.close());
    }

    public ManagedCommandDispatcherFactory(CommandDispatcherFactory factory) {
        this(factory, () -> {});
    }

    private ManagedCommandDispatcherFactory(CommandDispatcherFactory factory, Runnable closeTask) {
        this.factory = factory;
        this.closeTask = closeTask;
    }

    @Override
    public void close() {
        this.closeTask.run();
    }

    public Group getGroup() {
        return this.factory.getGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C> CommandDispatcher<C> createCommandDispatcher(Object id, C context) {
        Map<Object, Map.Entry<CommandDispatcher<?>, Integer>> map = this.dispatchers;
        synchronized (map) {
            Map.Entry<CommandDispatcher<?>, Integer> existingEntry = this.dispatchers.get(id);
            if (existingEntry == null) {
                CommandDispatcher dispatcher = this.factory.createCommandDispatcher(id, context);
                ManagedCommandDispatcher result = new ManagedCommandDispatcher(dispatcher, () -> {
                    Map<Object, Map.Entry<CommandDispatcher<?>, Integer>> map = this.dispatchers;
                    synchronized (map) {
                        Map.Entry<CommandDispatcher<?>, Integer> entry;
                        Map.Entry<CommandDispatcher<?>, Integer> entry2 = entry = this.dispatchers.get(id);
                        synchronized (entry2) {
                            int refs = entry.getValue() - 1;
                            if (refs == 0) {
                                dispatcher.close();
                                this.dispatchers.remove(id);
                            } else {
                                entry.setValue(refs);
                            }
                        }
                    }
                });
                this.dispatchers.put(id, new AbstractMap.SimpleEntry(result, 1));
                return result;
            }
            CommandDispatcher<?> result = existingEntry.getKey();
            if (result.getContext() != context) {
                throw ClusteringServerLogger.ROOT_LOGGER.commandDispatcherContextMismatch(id);
            }
            Map.Entry<CommandDispatcher<?>, Integer> entry = existingEntry;
            synchronized (entry) {
                int refs = existingEntry.getValue() + 1;
                existingEntry.setValue(refs);
            }
            return result;
        }
    }
}

