/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.clustering.function.Consumers;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.registry.RegistryFactory;
import org.wildfly.clustering.service.AsynchronousServiceBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.SuppliedValueService;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;

public class RegistryBuilder<K, V>
implements CapabilityServiceBuilder<Registry<K, V>>,
Supplier<Registry<K, V>> {
    private final ServiceName name;
    private final String containerName;
    private final String cacheName;
    private volatile ValueDependency<RegistryFactory<K, V>> factory;
    private volatile ValueDependency<Map.Entry<K, V>> entry;

    public RegistryBuilder(ServiceName name, String containerName, String cacheName) {
        this.name = name;
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    @Override
    public Registry<K, V> get() {
        return ((RegistryFactory)this.factory.getValue()).createRegistry((Map.Entry)this.entry.getValue());
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public Builder<Registry<K, V>> configure(CapabilityServiceSupport support) {
        this.factory = new InjectedValueDependency(ClusteringCacheRequirement.REGISTRY_FACTORY.getServiceName(support, this.containerName, this.cacheName), RegistryFactory.class);
        this.entry = new InjectedValueDependency(ClusteringCacheRequirement.REGISTRY_ENTRY.getServiceName(support, this.containerName, this.cacheName), Map.Entry.class);
        return this;
    }

    public ServiceBuilder<Registry<K, V>> build(ServiceTarget target) {
        SuppliedValueService service = new SuppliedValueService(Function.identity(), (Supplier)this, Consumers.close());
        ServiceBuilder builder = new AsynchronousServiceBuilder(this.name, (Service)service).build(target).setInitialMode(ServiceController.Mode.ON_DEMAND);
        return new CompositeDependency(new Dependency[]{this.factory, this.entry}).register(builder);
    }
}

