/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.net.URI;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wildfly.common.math.HashMath;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.client.MatchNetworkRule;
import org.wildfly.security.auth.client.MatchRule;

class MatchHostRule
extends MatchRule {
    private static final Pattern validHostSpecPattern = Pattern.compile("(\\*\\.)?([-a-z0-9_]+(?:\\.[-a-z0-9_]+)*)", 2);
    private final boolean suffixMatch;
    private final String hostSpec;

    MatchHostRule(MatchRule parent, String hostSpec) {
        super(parent.without(MatchNetworkRule.class));
        Matcher matcher = validHostSpecPattern.matcher(hostSpec);
        if (!matcher.matches()) {
            throw ElytronMessages.log.invalidHostSpec(hostSpec);
        }
        this.suffixMatch = matcher.group(1) != null;
        this.hostSpec = matcher.group(2).toLowerCase(Locale.ROOT);
    }

    @Override
    public boolean matches(URI uri, String abstractType, String abstractTypeAuthority) {
        String host = uri.getHost();
        if (host == null) {
            return false;
        }
        String canonHost = host.toLowerCase(Locale.ROOT);
        if (this.suffixMatch) {
            if (canonHost.equals(this.hostSpec)) {
                return super.matches(uri, abstractType, abstractTypeAuthority);
            }
            if (canonHost.endsWith(this.hostSpec)) {
                assert (canonHost.length() > this.hostSpec.length());
                return canonHost.codePointBefore(canonHost.length() - this.hostSpec.length()) == 46 && super.matches(uri, abstractType, abstractTypeAuthority);
            }
            return false;
        }
        return canonHost.equals(this.hostSpec) && super.matches(uri, abstractType, abstractTypeAuthority);
    }

    @Override
    MatchRule reparent(MatchRule newParent) {
        return new MatchHostRule(newParent, this.hostSpec);
    }

    @Override
    public String getMatchHost() {
        return this.hostSpec;
    }

    @Override
    public boolean isHostMatched() {
        return true;
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashUnordered(this.parentHashCode(), 2011, this.hostSpec.hashCode());
    }

    @Override
    boolean halfEqual(MatchRule other) {
        return this.hostSpec.equals(other.getMatchHost()) && this.parentHalfEqual(other);
    }

    @Override
    StringBuilder asString(StringBuilder b) {
        return this.parentAsString(b).append("host=").append(this.hostSpec).append(',');
    }
}

