/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.el.ValueExpression;
import javax.faces.component.UIComponentBase;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class UIWebsocket
extends UIComponentBase
implements ClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "javax.faces.Websocket";
    public static final String COMPONENT_FAMILY = "javax.faces.Script";
    private static final Pattern PATTERN_CHANNEL_NAME = Pattern.compile("[\\w.-]+");
    private static final String ERROR_ENDPOINT_NOT_ENABLED = "f:websocket endpoint is not enabled. You need to set web.xml context param 'javax.faces.ENABLE_WEBSOCKET_ENDPOINT' with value 'true'.";
    private static final String ERROR_INVALID_CHANNEL = "f:websocket 'channel' attribute '%s' does not represent a valid channel name. It is required, it may not be an  EL expression and it may only contain alphanumeric characters, hyphens, underscores and periods.";
    private static final String ERROR_INVALID_USER = "f:websocket 'user' attribute '%s' does not represent a valid user identifier. It must implement Serializable and preferably have low memory footprint. Suggestion: use #{request.remoteUser} or #{someLoggedInUser.id}.";
    private static final Collection<String> CONTAINS_EVERYTHING = Collections.unmodifiableList(new ArrayList<String>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean contains(Object object) {
            return true;
        }
    });

    public UIWebsocket() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        if (!Boolean.parseBoolean(externalContext.getInitParameter("javax.faces.ENABLE_WEBSOCKET_ENDPOINT"))) {
            throw new IllegalStateException(ERROR_ENDPOINT_NOT_ENABLED);
        }
    }

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    @Override
    public void setValueExpression(String name, ValueExpression binding) {
        Object user;
        if (PropertyKeys.channel.toString().equals(name) || PropertyKeys.scope.toString().equals(name)) {
            throw new IllegalArgumentException(name);
        }
        if (PropertyKeys.user.toString().equals(name) && (user = binding.getValue(this.getFacesContext().getELContext())) != null && !(user instanceof Serializable)) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_USER, user));
        }
        super.setValueExpression(name, binding);
    }

    @Override
    public Collection<String> getEventNames() {
        return CONTAINS_EVERYTHING;
    }

    public String getChannel() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.channel));
    }

    public void setChannel(String channel) {
        if (channel == null || !PATTERN_CHANNEL_NAME.matcher(channel).matches()) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_CHANNEL, channel));
        }
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.channel), channel);
    }

    public String getScope() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scope));
    }

    public void setScope(String scope) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scope), scope);
    }

    public Serializable getUser() {
        return (Serializable)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.user));
    }

    public void setUser(Serializable user) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.user), user);
    }

    public String getOnopen() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onopen));
    }

    public void setOnopen(String onopen) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onopen), onopen);
    }

    public String getOnmessage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onmessage));
    }

    public void setOnmessage(String onmessage) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onmessage), onmessage);
    }

    public String getOnclose() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onclose));
    }

    public void setOnclose(String onclose) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onclose), onclose);
    }

    public boolean isConnected() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.connected), Boolean.TRUE);
    }

    public void setConnected(boolean connected) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.connected), connected);
    }

    static enum PropertyKeys {
        channel,
        scope,
        user,
        onopen,
        onmessage,
        onclose,
        connected;

    }
}

