/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.helpers.standalone.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.helpers.standalone.AddDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ReplaceDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.UndeployDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.impl.DeploymentActionImpl;
import org.jboss.as.controller.client.helpers.standalone.impl.DeploymentPlanImpl;
import org.jboss.as.controller.client.helpers.standalone.impl.ReplaceDeploymentPlanBuilderImpl;
import org.jboss.as.controller.client.impl.InputStreamEntry;
import org.jboss.as.controller.client.logging.ControllerClientLogger;
import org.jboss.as.protocol.StreamUtils;

class DeploymentPlanBuilderImpl
implements AddDeploymentPlanBuilder,
InitialDeploymentPlanBuilder,
UndeployDeploymentPlanBuilder {
    private final boolean shutdown;
    private final long gracefulShutdownPeriod;
    private final boolean globalRollback;
    private volatile boolean cleanupInFinalize = true;
    private final List<DeploymentActionImpl> deploymentActions = new ArrayList<DeploymentActionImpl>();

    DeploymentPlanBuilderImpl() {
        this.shutdown = false;
        this.globalRollback = true;
        this.gracefulShutdownPeriod = -1L;
    }

    DeploymentPlanBuilderImpl(DeploymentPlanBuilderImpl existing) {
        this.deploymentActions.addAll(existing.deploymentActions);
        this.shutdown = existing.shutdown;
        this.globalRollback = existing.globalRollback;
        this.gracefulShutdownPeriod = existing.gracefulShutdownPeriod;
        existing.cleanupInFinalize = false;
    }

    DeploymentPlanBuilderImpl(DeploymentPlanBuilderImpl existing, boolean globalRollback) {
        this.deploymentActions.addAll(existing.deploymentActions);
        this.shutdown = false;
        this.globalRollback = globalRollback;
        this.gracefulShutdownPeriod = -1L;
        existing.cleanupInFinalize = false;
    }

    DeploymentPlanBuilderImpl(DeploymentPlanBuilderImpl existing, long gracefulShutdownPeriod) {
        this.deploymentActions.addAll(existing.deploymentActions);
        this.shutdown = true;
        this.globalRollback = false;
        this.gracefulShutdownPeriod = gracefulShutdownPeriod;
        existing.cleanupInFinalize = false;
    }

    DeploymentPlanBuilderImpl(DeploymentPlanBuilderImpl existing, DeploymentActionImpl modification) {
        this(existing);
        this.deploymentActions.add(modification);
    }

    @Override
    public DeploymentAction getLastAction() {
        return this.deploymentActions.size() == 0 ? null : (DeploymentAction)this.deploymentActions.get(this.deploymentActions.size() - 1);
    }

    @Override
    public List<DeploymentAction> getDeploymentActions() {
        return new ArrayList<DeploymentAction>(this.deploymentActions);
    }

    @Override
    public long getGracefulShutdownTimeout() {
        return this.gracefulShutdownPeriod;
    }

    @Override
    public boolean isGlobalRollback() {
        return this.globalRollback;
    }

    @Override
    public boolean isGracefulShutdown() {
        return this.shutdown && this.gracefulShutdownPeriod > -1L;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public DeploymentPlan build() {
        DeploymentPlanImpl dp = new DeploymentPlanImpl(Collections.unmodifiableList(this.deploymentActions), this.globalRollback, this.shutdown, this.gracefulShutdownPeriod);
        this.cleanupInFinalize = false;
        return dp;
    }

    @Override
    public AddDeploymentPlanBuilder add(File file) throws IOException {
        String name = file.getName();
        return this.add(name, file);
    }

    @Override
    public AddDeploymentPlanBuilder add(URL url) throws IOException {
        String name = this.getName(url);
        return this.add(name, name, url);
    }

    @Override
    public AddDeploymentPlanBuilder add(String name, File file) throws IOException {
        return this.add(name, name, new InputStreamEntry.FileStreamEntry(file), true);
    }

    @Override
    public AddDeploymentPlanBuilder add(String name, URL url) throws IOException {
        return this.add(name, name, url);
    }

    private AddDeploymentPlanBuilder add(String name, String commonName, URL url) throws IOException {
        try {
            URLConnection conn = url.openConnection();
            conn.connect();
            InputStream stream = conn.getInputStream();
            return this.add(name, commonName, stream, true);
        }
        catch (IOException e) {
            this.cleanup();
            throw e;
        }
    }

    private DeploymentPlanBuilder replace(String name, String commonName, URL url) throws IOException {
        try {
            URLConnection conn = url.openConnection();
            conn.connect();
            InputStream stream = conn.getInputStream();
            return this.replace(name, commonName, stream, true);
        }
        catch (IOException e) {
            this.cleanup();
            throw e;
        }
    }

    @Override
    public AddDeploymentPlanBuilder add(String name, InputStream stream) {
        return this.add(name, name, stream);
    }

    @Override
    public AddDeploymentPlanBuilder add(String name, String commonName, InputStream stream) {
        return this.add(name, commonName, stream, false);
    }

    private AddDeploymentPlanBuilder add(String name, String commonName, InputStream stream, boolean internalStream) {
        DeploymentActionImpl mod = DeploymentActionImpl.getAddAction(name, commonName, stream, internalStream);
        return new DeploymentPlanBuilderImpl(this, mod);
    }

    @Override
    public DeploymentPlanBuilder andDeploy() {
        String addedKey = this.getAddedContentKey();
        DeploymentActionImpl deployMod = DeploymentActionImpl.getDeployAction(addedKey);
        return new DeploymentPlanBuilderImpl(this, deployMod);
    }

    @Override
    public ReplaceDeploymentPlanBuilder andReplace(String toReplace) {
        String newContentKey = this.getAddedContentKey();
        return this.replace(newContentKey, toReplace);
    }

    @Override
    public DeploymentPlanBuilder deploy(String key) {
        DeploymentActionImpl mod = DeploymentActionImpl.getDeployAction(key);
        return new DeploymentPlanBuilderImpl(this, mod);
    }

    @Override
    public UndeployDeploymentPlanBuilder undeploy(String key) {
        DeploymentActionImpl mod = DeploymentActionImpl.getUndeployAction(key);
        return new DeploymentPlanBuilderImpl(this, mod);
    }

    @Override
    public DeploymentPlanBuilder redeploy(String deploymentName) {
        DeploymentActionImpl mod = DeploymentActionImpl.getRedeployAction(deploymentName);
        return new DeploymentPlanBuilderImpl(this, mod);
    }

    @Override
    public ReplaceDeploymentPlanBuilder replace(String replacement, String toReplace) {
        DeploymentActionImpl mod = DeploymentActionImpl.getReplaceAction(replacement, toReplace);
        return new ReplaceDeploymentPlanBuilderImpl(this, mod);
    }

    @Override
    public DeploymentPlanBuilder replace(File file) throws IOException {
        String name = file.getName();
        return this.replace(name, file);
    }

    @Override
    public DeploymentPlanBuilder replace(URL url) throws IOException {
        String name = this.getName(url);
        return this.replace(name, name, url);
    }

    @Override
    public DeploymentPlanBuilder replace(String name, File file) throws IOException {
        return this.replace(name, name, new InputStreamEntry.FileStreamEntry(file), true);
    }

    @Override
    public DeploymentPlanBuilder replace(String name, URL url) throws IOException {
        return this.replace(name, name, url);
    }

    @Override
    public DeploymentPlanBuilder replace(String name, InputStream stream) {
        return this.replace(name, name, stream);
    }

    @Override
    public DeploymentPlanBuilder replace(String name, String commonName, InputStream stream) {
        return this.replace(name, commonName, stream, false);
    }

    private DeploymentPlanBuilder replace(String name, String commonName, InputStream stream, boolean internalStream) {
        DeploymentActionImpl mod = DeploymentActionImpl.getFullReplaceAction(name, commonName, stream, internalStream);
        return new DeploymentPlanBuilderImpl(this, mod);
    }

    @Override
    public DeploymentPlanBuilder andRemoveUndeployed() {
        DeploymentAction last = this.getLastAction();
        if (last.getType() != DeploymentAction.Type.UNDEPLOY) {
            this.cleanup();
            throw ControllerClientLogger.ROOT_LOGGER.invalidPrecedingAction((Object)DeploymentAction.Type.UNDEPLOY);
        }
        DeploymentActionImpl removeMod = DeploymentActionImpl.getRemoveAction(last.getDeploymentUnitUniqueName());
        return new DeploymentPlanBuilderImpl(this, removeMod);
    }

    @Override
    public DeploymentPlanBuilder remove(String key) {
        DeploymentActionImpl removeMod = DeploymentActionImpl.getRemoveAction(key);
        return new DeploymentPlanBuilderImpl(this, removeMod);
    }

    @Override
    @Deprecated
    public DeploymentPlanBuilder withRollback() {
        if (this.deploymentActions.size() > 0) {
            this.cleanup();
            throw ControllerClientLogger.ROOT_LOGGER.operationsNotAllowed(InitialDeploymentPlanBuilder.class.getSimpleName());
        }
        if (this.shutdown) {
            this.cleanup();
            throw ControllerClientLogger.ROOT_LOGGER.globalRollbackNotCompatible();
        }
        return new DeploymentPlanBuilderImpl(this, true);
    }

    @Override
    public DeploymentPlanBuilder withoutRollback() {
        if (this.deploymentActions.size() > 0) {
            this.cleanup();
            throw ControllerClientLogger.ROOT_LOGGER.operationsNotAllowed(InitialDeploymentPlanBuilder.class.getSimpleName());
        }
        return new DeploymentPlanBuilderImpl(this, false);
    }

    @Override
    public DeploymentPlanBuilder withGracefulShutdown(long timeout, TimeUnit timeUnit) {
        if (this.deploymentActions.size() > 0) {
            this.cleanup();
            throw ControllerClientLogger.ROOT_LOGGER.operationsNotAllowed(InitialDeploymentPlanBuilder.class.getSimpleName());
        }
        if (this.globalRollback) {
            this.cleanup();
            throw ControllerClientLogger.ROOT_LOGGER.globalRollbackNotCompatible();
        }
        long period = timeUnit.toMillis(timeout);
        if (this.shutdown && period != this.gracefulShutdownPeriod) {
            this.cleanup();
            throw ControllerClientLogger.ROOT_LOGGER.gracefulShutdownAlreadyConfigured(this.gracefulShutdownPeriod);
        }
        return new DeploymentPlanBuilderImpl(this, period);
    }

    @Override
    public DeploymentPlanBuilder withShutdown() {
        if (this.deploymentActions.size() > 0) {
            this.cleanup();
            throw ControllerClientLogger.ROOT_LOGGER.operationsNotAllowed(InitialDeploymentPlanBuilder.class.getSimpleName());
        }
        if (this.globalRollback) {
            this.cleanup();
            throw ControllerClientLogger.ROOT_LOGGER.globalRollbackNotCompatible();
        }
        if (this.shutdown && this.gracefulShutdownPeriod != -1L) {
            this.cleanup();
            throw ControllerClientLogger.ROOT_LOGGER.gracefulShutdownAlreadyConfigured(this.gracefulShutdownPeriod);
        }
        return new DeploymentPlanBuilderImpl(this, -1L);
    }

    private String getAddedContentKey() {
        DeploymentAction last = this.getLastAction();
        if (last.getType() != DeploymentAction.Type.ADD) {
            this.cleanup();
            throw ControllerClientLogger.ROOT_LOGGER.invalidPrecedingAction((Object)DeploymentAction.Type.ADD);
        }
        return last.getDeploymentUnitUniqueName();
    }

    private String getName(URL url) {
        if ("file".equals(url.getProtocol())) {
            try {
                File f = new File(url.toURI());
                return f.getName();
            }
            catch (URISyntaxException e) {
                this.cleanup();
                throw ControllerClientLogger.ROOT_LOGGER.invalidUri(e, url);
            }
        }
        String path = url.getPath();
        int idx = path.lastIndexOf(47);
        while (idx == path.length() - 1) {
            path = path.substring(0, idx);
            idx = path.lastIndexOf(47);
        }
        if (idx == -1) {
            this.cleanup();
            throw ControllerClientLogger.ROOT_LOGGER.cannotDeriveDeploymentName(url);
        }
        return path.substring(idx + 1);
    }

    protected void cleanup() {
        for (DeploymentActionImpl action : this.deploymentActions) {
            if (!action.isInternalStream() || action.getContentStream() == null) continue;
            StreamUtils.safeClose((Closeable)action.getContentStream());
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.cleanupInFinalize) {
            this.cleanup();
        }
    }

    @Override
    public DeploymentPlanBuilder explodeDeployment(String deploymentName) throws IOException {
        DeploymentActionImpl mod = DeploymentActionImpl.getExplodeAction(deploymentName, null);
        return new DeploymentPlanBuilderImpl(this, mod);
    }

    @Override
    public DeploymentPlanBuilder explodeDeploymentContent(String deploymentName, String path) throws IOException {
        DeploymentActionImpl mod = DeploymentActionImpl.getExplodeAction(deploymentName, path);
        return new DeploymentPlanBuilderImpl(this, mod);
    }

    @Override
    public DeploymentPlanBuilder addContentToDeployment(String deploymentName, Map<String, InputStream> contents) throws IOException {
        DeploymentActionImpl mod = DeploymentActionImpl.getAddContentAction(deploymentName, contents);
        return new DeploymentPlanBuilderImpl(this, mod);
    }

    @Override
    public DeploymentPlanBuilder addContentFileToDeployment(String deploymentName, Map<String, Path> files) throws IOException {
        DeploymentActionImpl mod = DeploymentActionImpl.getAddContentFileAction(deploymentName, files);
        return new DeploymentPlanBuilderImpl(this, mod);
    }

    @Override
    public DeploymentPlanBuilder removeContenFromDeployment(String deploymentName, List<String> paths) throws IOException {
        DeploymentActionImpl mod = DeploymentActionImpl.getRemoveContentAction(deploymentName, paths);
        return new DeploymentPlanBuilderImpl(this, mod);
    }
}

