/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.internal.el;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.el.FunctionMapper;
import org.picketlink.internal.el.ELFunctionMethods;

public class PicketLinkFunctionMapper
extends FunctionMapper {
    private static final String DEFAULT_NAMESPACE = "p";
    private static final Map<String, Method> builtInFunctions = new HashMap<String, Method>();
    private final Map<String, Method> userDefinedFunctions = new HashMap<String, Method>();

    public Method resolveFunction(String prefix, String localName) {
        String key;
        Method function;
        if (prefix.length() == 0) {
            prefix = DEFAULT_NAMESPACE;
        }
        if ((function = builtInFunctions.get(key = prefix + ":" + localName)) == null) {
            function = this.userDefinedFunctions.get(key);
        }
        return function;
    }

    private static void addFunction(String name, Method functionMethod) {
        builtInFunctions.put("p:" + name, functionMethod);
    }

    static {
        try {
            PicketLinkFunctionMapper.addFunction("isLoggedIn", ELFunctionMethods.class.getMethod("isLoggedIn", new Class[0]));
            PicketLinkFunctionMapper.addFunction("hasPermission", ELFunctionMethods.class.getMethod("hasPermission", Object.class, String.class));
            PicketLinkFunctionMapper.addFunction("hasRole", ELFunctionMethods.class.getMethod("hasRole", String.class));
            PicketLinkFunctionMapper.addFunction("hasPartition", ELFunctionMethods.class.getMethod("hasPartition", String.class));
            PicketLinkFunctionMapper.addFunction("hasAttribute", ELFunctionMethods.class.getMethod("hasAttribute", String.class));
            PicketLinkFunctionMapper.addFunction("isMember", ELFunctionMethods.class.getMethod("isMember", String.class));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Error configuring built-in EL functions.", e);
        }
    }
}

