/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.Vetoed;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.jboss.weld.resources.WeldClassLoaderResourceLoader;

@Vetoed
class ProbeDynamicMBean
extends StandardMBean {
    private static final Map<String, Class<?>> PRIMITIVES_MAP = new HashMap();
    private final Class<?> mbeanInterface;

    <T> ProbeDynamicMBean(T implementation, Class<T> mbeanInterface) throws NotCompliantMBeanException {
        super(implementation, mbeanInterface, true);
        PRIMITIVES_MAP.put(Byte.TYPE.getName(), Byte.TYPE);
        PRIMITIVES_MAP.put(Short.TYPE.getName(), Short.TYPE);
        PRIMITIVES_MAP.put(Integer.TYPE.getName(), Integer.TYPE);
        PRIMITIVES_MAP.put(Long.TYPE.getName(), Long.TYPE);
        PRIMITIVES_MAP.put(Float.TYPE.getName(), Float.TYPE);
        PRIMITIVES_MAP.put(Double.TYPE.getName(), Double.TYPE);
        PRIMITIVES_MAP.put(Character.TYPE.getName(), Character.TYPE);
        PRIMITIVES_MAP.put(Boolean.TYPE.getName(), Boolean.TYPE);
        this.mbeanInterface = mbeanInterface;
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        Description description;
        Method found = this.findMethod(info);
        if (found != null && (description = found.getAnnotation(Description.class)) != null) {
            return description.value();
        }
        return super.getDescription(info);
    }

    @Override
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        Method found = this.findMethod(op);
        if (found != null) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = found.getParameterAnnotations()[sequence]) {
                if (!annotation.annotationType().equals(ParamName.class)) continue;
                return ((ParamName)annotation).value();
            }
        }
        return super.getParameterName(op, param, sequence);
    }

    @Override
    protected String getDescription(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        Method found = this.findMethod(op);
        if (found != null) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = found.getParameterAnnotations()[sequence]) {
                if (!annotation.annotationType().equals(Description.class)) continue;
                return ((Description)annotation).value();
            }
        }
        return super.getDescription(op, param, sequence);
    }

    private Method findMethod(MBeanOperationInfo operationInfo) {
        try {
            return this.mbeanInterface.getMethod(operationInfo.getName(), this.toParamTypes(operationInfo.getSignature()));
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    private Class<?>[] toParamTypes(MBeanParameterInfo[] paramsInfo) {
        Class[] paramTypes = new Class[paramsInfo.length];
        for (int i = 0; i < paramsInfo.length; ++i) {
            paramTypes[i] = this.classForName(paramsInfo[i].getType());
        }
        return paramTypes;
    }

    private Class<?> classForName(String name) {
        Class clazz = PRIMITIVES_MAP.get(name);
        if (clazz == null) {
            clazz = WeldClassLoaderResourceLoader.INSTANCE.classForName(name);
        }
        return clazz;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    static @interface ParamName {
        public String value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.PARAMETER})
    static @interface Description {
        public String value();
    }
}

