/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class EnvConfigSource
implements ConfigSource,
Serializable {
    EnvConfigSource() {
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(System.getenv());
    }

    public int getOrdinal() {
        return 300;
    }

    public String getValue(String name) {
        if (name == null) {
            return null;
        }
        String value = System.getenv(name);
        if (value != null) {
            return value;
        }
        value = System.getenv(name = name.replaceAll("[^a-zA-Z0-9_]", "_"));
        if (value != null) {
            return value;
        }
        return System.getenv(name.toUpperCase());
    }

    public String getName() {
        return "EnvConfigSource";
    }
}

