/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.doseta;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Priority;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.security.doseta.Verifications;
import org.jboss.resteasy.annotations.security.doseta.Verify;
import org.jboss.resteasy.security.doseta.AbstractDigitalVerificationHeaderDecorator;
import org.jboss.resteasy.security.doseta.DKIMSignature;
import org.jboss.resteasy.security.doseta.KeyRepository;
import org.jboss.resteasy.security.doseta.UnauthorizedSignatureException;
import org.jboss.resteasy.security.doseta.VerificationResults;
import org.jboss.resteasy.security.doseta.Verifier;
import org.jboss.resteasy.security.doseta.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@Provider
@ConstrainedTo(value=RuntimeType.SERVER)
public class ServerDigitalVerificationHeaderDecoratorFeature
implements DynamicFeature {
    public void configure(ResourceInfo resourceInfo, FeatureContext configurable) {
        Verify verify = resourceInfo.getResourceMethod().getAnnotation(Verify.class);
        Verifications verifications = resourceInfo.getResourceClass().getAnnotation(Verifications.class);
        resourceInfo.getResourceMethod();
        if (verify != null || verifications != null) {
            configurable.register((Object)new DigitalVerificationHeaderDecorator(verify, verifications, ServerDigitalVerificationHeaderDecoratorFeature.hasEntityParameter(resourceInfo.getResourceMethod())));
        }
    }

    static boolean hasEntityParameter(Method method) {
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            boolean match = false;
            for (int j = 0; j < annotations[i].length; ++j) {
                if (!annotations[i][j].annotationType().equals(MatrixParam.class) && !annotations[i][j].annotationType().equals(QueryParam.class) && !annotations[i][j].annotationType().equals(PathParam.class) && !annotations[i][j].annotationType().equals(CookieParam.class) && !annotations[i][j].annotationType().equals(HeaderParam.class) && !annotations[i][j].annotationType().equals(Context.class) && !annotations[i][j].annotationType().equals(FormParam.class)) continue;
                match = true;
                break;
            }
            if (match) continue;
            return true;
        }
        return false;
    }

    protected static void verify(ContainerRequestContext context, Verifier verifier) {
        VerificationResults results;
        MultivaluedMap headers = context.getHeaders();
        List strings = (List)headers.get((Object)"DKIM-Signature");
        if (strings == null) {
            throw new UnauthorizedSignatureException(Messages.MESSAGES.thereWasNoSignatureHeader("DKIM-Signature"));
        }
        ArrayList<DKIMSignature> signatures = new ArrayList<DKIMSignature>();
        for (String headerVal : strings) {
            try {
                signatures.add(new DKIMSignature(headerVal));
            }
            catch (Exception e) {
                throw new UnauthorizedSignatureException(Messages.MESSAGES.malformedSignatureHeader("DKIM-Signature"));
            }
        }
        if (verifier.getRepository() == null) {
            KeyRepository repository = (KeyRepository)context.getProperty(KeyRepository.class.getName());
            if (repository == null) {
                repository = (KeyRepository)ResteasyProviderFactory.getContextData(KeyRepository.class);
            }
            verifier.setRepository(repository);
        }
        if (!(results = verifier.verify(signatures, (Map)headers, null)).isVerified()) {
            throw new UnauthorizedSignatureException(results);
        }
    }

    @Priority(value=3000)
    public static class DigitalVerificationHeaderDecorator
    extends AbstractDigitalVerificationHeaderDecorator
    implements ContainerRequestFilter {
        protected boolean hasEntityParameter;

        public DigitalVerificationHeaderDecorator(Verify verify, Verifications verifications, boolean hasEntityParameter) {
            this.verify = verify;
            this.verifications = verifications;
            this.hasEntityParameter = hasEntityParameter;
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            if (this.hasEntityParameter) {
                requestContext.setProperty(Verifier.class.getName(), (Object)this.create());
            } else {
                ServerDigitalVerificationHeaderDecoratorFeature.verify(requestContext, this.create());
            }
        }
    }
}

