/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.function.BiConsumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

class UrlScanner {
    private final URL beansXmlUrl;
    private final BiConsumer<String, ClassFile> classConsumer;

    UrlScanner(URL beansXmlUrl, BiConsumer<String, ClassFile> classConsumer) {
        this.beansXmlUrl = beansXmlUrl;
        this.classConsumer = classConsumer;
    }

    boolean scan() {
        String urlPath = this.beansXmlUrl.toExternalForm();
        String urlType = "file";
        int colonIndex = urlPath.indexOf(":");
        if (colonIndex != -1) {
            urlType = urlPath.substring(0, colonIndex);
        }
        if ("file".equals(urlType) || "jar".equals(urlType)) {
            urlPath = this.beansXmlUrl.getPath();
            if (urlPath.indexOf(33) > 0) {
                urlPath = urlPath.substring(0, urlPath.indexOf(33));
            } else {
                File dirOrArchive = new File(urlPath);
                dirOrArchive = dirOrArchive.getParentFile();
                urlPath = dirOrArchive.getParent();
            }
            try {
                urlPath = URLDecoder.decode(urlPath, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            this.handle(urlPath);
            return true;
        }
        if ("vfs".equals(urlType)) {
            try {
                VirtualFile vfsRoot = VFS.getChild((URL)this.beansXmlUrl).getParent().getParent();
                this.handle(vfsRoot);
                return true;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        WeldLogger.DEPLOYMENT_LOGGER.doNotUnderstandProtocol(this.beansXmlUrl);
        return false;
    }

    private void handle(VirtualFile urlPath) {
        WeldLogger.DEPLOYMENT_LOGGER.tracef("scanning: %s", (Object)urlPath);
        this.handleDirectory(urlPath, null);
    }

    private void handle(String urlPath) {
        try {
            File file;
            WeldLogger.DEPLOYMENT_LOGGER.tracef("scanning: %s", (Object)urlPath);
            if (urlPath.startsWith("file:")) {
                urlPath = urlPath.substring(5);
            }
            if (urlPath.indexOf(33) > 0) {
                urlPath = urlPath.substring(0, urlPath.indexOf(33));
            }
            if ((file = new File(urlPath)).isDirectory()) {
                this.handleDirectory(file, null);
            } else {
                this.handleArchiveByFile(file);
            }
        }
        catch (IOException ioe) {
            WeldLogger.DEPLOYMENT_LOGGER.couldNotReadEntries(ioe);
        }
    }

    private void handleArchiveByFile(File file) throws IOException {
        try {
            WeldLogger.DEPLOYMENT_LOGGER.trace((Object)("archive: " + file));
            try (ZipFile zip = new ZipFile(file);){
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    this.handleFile(name, () -> zip.getInputStream(entry));
                }
            }
        }
        catch (ZipException e) {
            throw new RuntimeException("Error handling file " + file, e);
        }
    }

    private void handleDirectory(File file, String path) {
        WeldLogger.DEPLOYMENT_LOGGER.tracef("handling directory: %s", (Object)file);
        for (File child : file.listFiles()) {
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.handleDirectory(child, newPath);
                continue;
            }
            this.handleFile(newPath, () -> child.toURI().toURL().openStream());
        }
    }

    private void handleDirectory(VirtualFile file, String path) {
        WeldLogger.DEPLOYMENT_LOGGER.tracef("handling directory: %s", (Object)file);
        for (VirtualFile child : file.getChildren()) {
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.handleDirectory(child, newPath);
                continue;
            }
            this.handleFile(newPath, () -> file.toURL().openStream());
        }
    }

    protected void handleFile(String name, ClassFile loader) {
        if (name.endsWith(".class")) {
            this.classConsumer.accept(UrlScanner.filenameToClassname(name), loader);
        }
    }

    public static String filenameToClassname(String filename) {
        return filename.substring(0, filename.lastIndexOf(".class")).replace('/', '.').replace('\\', '.');
    }

    @FunctionalInterface
    static interface ClassFile {
        public InputStream openStream() throws IOException;
    }
}

