/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import javax.jms.Message;
import javax.jms.MessageListener;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.MessageHandler;
import org.hornetq.jms.client.HornetQConnection;
import org.hornetq.jms.client.HornetQJMSClientLogger;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.jms.client.HornetQSession;

public class JMSMessageListenerWrapper
implements MessageHandler {
    private final HornetQConnection connection;
    private final HornetQSession session;
    private final MessageListener listener;
    private final ClientConsumer consumer;
    private final boolean transactedOrClientAck;
    private final boolean individualACK;

    protected JMSMessageListenerWrapper(HornetQConnection connection, HornetQSession session, ClientConsumer consumer, MessageListener listener, int ackMode) {
        this.connection = connection;
        this.session = session;
        this.consumer = consumer;
        this.listener = listener;
        this.transactedOrClientAck = ackMode == 0 || ackMode == 2 || session.isXA();
        this.individualACK = ackMode == 101;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ClientMessage message) {
        HornetQMessage msg = HornetQMessage.createMessage(message, this.session.getCoreSession());
        if (this.individualACK) {
            msg.setIndividualAcknowledge();
        }
        try {
            msg.doBeforeReceive();
        }
        catch (Exception e) {
            HornetQJMSClientLogger.LOGGER.errorPreparingMessageForReceipt(e);
            return;
        }
        if (this.transactedOrClientAck) {
            try {
                message.acknowledge();
            }
            catch (HornetQException e) {
                HornetQJMSClientLogger.LOGGER.errorProcessingMessage(e);
            }
        }
        try {
            this.connection.getThreadAwareContext().setCurrentThread(false);
            this.listener.onMessage((Message)msg);
        }
        catch (RuntimeException e) {
            HornetQJMSClientLogger.LOGGER.onMessageError(e);
            if (!this.transactedOrClientAck) {
                try {
                    if (this.individualACK) {
                        message.individualAcknowledge();
                    }
                    this.session.getCoreSession().rollback(true);
                    this.session.setRecoverCalled(true);
                }
                catch (Exception e2) {
                    HornetQJMSClientLogger.LOGGER.errorRecoveringSession(e2);
                }
            }
        }
        finally {
            this.connection.getThreadAwareContext().clearCurrentThread(false);
        }
        if (!this.session.isRecoverCalled() && !this.individualACK) {
            try {
                if (!this.consumer.isClosed() && !this.transactedOrClientAck) {
                    message.acknowledge();
                }
            }
            catch (HornetQException e) {
                HornetQJMSClientLogger.LOGGER.errorProcessingMessage(e);
            }
        }
        this.session.setRecoverCalled(false);
    }
}

