/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction.impl;

import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.impl.ImmutableContext;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.impl.CacheMgmtInterceptor;
import org.infinispan.notifications.cachelistener.CacheNotifier;

@ThreadSafe
public class EvictionManagerImpl<K, V>
implements EvictionManager<K, V> {
    @Inject
    private CacheNotifier<K, V> cacheNotifier;
    @Inject
    private AsyncInterceptorChain interceptorChain;
    @Inject
    private Configuration cfg;

    @Override
    public void onEntryEviction(Map<? extends K, InternalCacheEntry<? extends K, ? extends V>> evicted) {
        ImmutableContext ctx = ImmutableContext.INSTANCE;
        this.cacheNotifier.notifyCacheEntriesEvicted(evicted.values(), ctx, null);
        if (this.cfg.jmxStatistics().enabled()) {
            this.updateEvictionStatistics(evicted);
        }
    }

    private void updateEvictionStatistics(Map<? extends K, InternalCacheEntry<? extends K, ? extends V>> evicted) {
        CacheMgmtInterceptor mgmtInterceptor = this.interceptorChain.findInterceptorExtending(CacheMgmtInterceptor.class);
        if (mgmtInterceptor != null) {
            mgmtInterceptor.addEvictions(evicted.size());
        }
    }
}

