/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.filter;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.metadata.Metadata;

public class CompositeKeyValueFilter<K, V>
implements KeyValueFilter<K, V> {
    private final KeyValueFilter<? super K, ? super V>[] filters;

    public CompositeKeyValueFilter(KeyValueFilter<? super K, ? super V> ... filters) {
        this.filters = filters;
    }

    @Override
    public boolean accept(K key, V value, Metadata metadata) {
        for (KeyValueFilter<K, V> keyValueFilter : this.filters) {
            if (keyValueFilter.accept(key, value, metadata)) continue;
            return false;
        }
        return true;
    }

    @Inject
    protected void injectDependencies(ComponentRegistry cr) {
        for (KeyValueFilter<? super K, ? super V> f : this.filters) {
            cr.wireDependencies(f);
        }
    }

    public static class Externalizer
    extends AbstractExternalizer<CompositeKeyValueFilter> {
        public Set<Class<? extends CompositeKeyValueFilter>> getTypeClasses() {
            return Collections.singleton(CompositeKeyValueFilter.class);
        }

        public void writeObject(ObjectOutput output, CompositeKeyValueFilter object) throws IOException {
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)object.filters.length);
            for (KeyValueFilter filter : object.filters) {
                output.writeObject(filter);
            }
        }

        public CompositeKeyValueFilter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int filtersSize = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            KeyValueFilter[] filters = new KeyValueFilter[filtersSize];
            for (int i = 0; i < filtersSize; ++i) {
                filters[i] = (KeyValueFilter)input.readObject();
            }
            return new CompositeKeyValueFilter(filters);
        }

        public Integer getId() {
            return 71;
        }
    }
}

